/*
 *  /MathJax/config/MML_HTMLorMML.js
 *  
 *  Copyright (c) 2010-2013 The MathJax Consortium
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 * 
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */

MathJax.Hub.Config({delayJaxRegistration: true});

MathJax.Ajax.Preloading(
  "[MathJax]/jax/input/MathML/config.js",
  "[MathJax]/jax/output/HTML-CSS/config.js",
  "[MathJax]/jax/output/NativeMML/config.js",
  "[MathJax]/config/MMLorHTML.js",
  "[MathJax]/extensions/mml2jax.js",
  "[MathJax]/extensions/MathEvents.js",
  "[MathJax]/extensions/MathZoom.js",
  "[MathJax]/extensions/MathMenu.js",
  "[MathJax]/jax/element/mml/jax.js",
  "[MathJax]/extensions/toMathML.js",
  "[MathJax]/jax/input/MathML/jax.js"
);

MathJax.Hub.Config({"v1.0-compatible":false});

MathJax.InputJax.MathML=MathJax.InputJax({id:"MathML",version:"2.3",directory:MathJax.InputJax.directory+"/MathML",extensionDir:MathJax.InputJax.extensionDir+"/MathML",entityDir:MathJax.InputJax.directory+"/MathML/entities",config:{useMathMLspacing:false}});MathJax.InputJax.MathML.Register("math/mml");MathJax.InputJax.MathML.loadComplete("config.js");
MathJax.OutputJax["HTML-CSS"]=MathJax.OutputJax({id:"HTML-CSS",version:"2.3",directory:MathJax.OutputJax.directory+"/HTML-CSS",extensionDir:MathJax.OutputJax.extensionDir+"/HTML-CSS",autoloadDir:MathJax.OutputJax.directory+"/HTML-CSS/autoload",fontDir:MathJax.OutputJax.directory+"/HTML-CSS/fonts",webfontDir:MathJax.OutputJax.fontDir+"/HTML-CSS",config:{matchFontHeight:true,scale:100,minScaleAdjust:50,availableFonts:["STIX","TeX"],preferredFont:"TeX",webFont:"TeX",imageFont:"TeX",undefinedFamily:"STIXGeneral,'Arial Unicode MS',serif",mtextFontInherit:false,EqnChunk:(MathJax.Hub.Browser.isMobile?10:50),EqnChunkFactor:1.5,EqnChunkDelay:100,linebreaks:{automatic:false,width:"container"},styles:{".MathJax_Display":{"text-align":"center",margin:"1em 0em"},".MathJax .merror":{"background-color":"#FFFF88",color:"#CC0000",border:"1px solid #CC0000",padding:"1px 3px","font-style":"normal","font-size":"90%"},"#MathJax_Tooltip":{"background-color":"InfoBackground",color:"InfoText",border:"1px solid black","box-shadow":"2px 2px 5px #AAAAAA","-webkit-box-shadow":"2px 2px 5px #AAAAAA","-moz-box-shadow":"2px 2px 5px #AAAAAA","-khtml-box-shadow":"2px 2px 5px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')",padding:"3px 4px","z-index":401}}}});if(MathJax.Hub.Browser.isMSIE&&document.documentMode>=9){delete MathJax.OutputJax["HTML-CSS"].config.styles["#MathJax_Tooltip"].filter}if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}MathJax.Hub.Register.StartupHook("End Config",[function(b,c){var a=b.Insert({minBrowserVersion:{Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4},inlineMathDelimiters:["$","$"],displayMathDelimiters:["$$","$$"],multilineDisplay:true,minBrowserTranslate:function(f){var e=b.getJaxFor(f),k=["[Math]"],j;var h=document.createElement("span",{className:"MathJax_Preview"});if(e.inputJax==="TeX"){if(e.root.Get("displaystyle")){j=a.displayMathDelimiters;k=[j[0]+e.originalText+j[1]];if(a.multilineDisplay){k=k[0].split(/\n/)}}else{j=a.inlineMathDelimiters;k=[j[0]+e.originalText.replace(/^\s+/,"").replace(/\s+$/,"")+j[1]]}}for(var g=0,d=k.length;g<d;g++){h.appendChild(document.createTextNode(k[g]));if(g<d-1){h.appendChild(document.createElement("br"))}}f.parentNode.insertBefore(h,f)}},(b.config["HTML-CSS"]||{}));if(b.Browser.version!=="0.0"&&!b.Browser.versionAtLeast(a.minBrowserVersion[b.Browser]||0)){c.Translate=a.minBrowserTranslate;b.Config({showProcessingMessages:false});MathJax.Message.Set(["MathJaxNotSupported","Your browser does not support MathJax"],null,4000);b.Startup.signal.Post("MathJax not supported")}},MathJax.Hub,MathJax.OutputJax["HTML-CSS"]]);MathJax.OutputJax["HTML-CSS"].loadComplete("config.js");
MathJax.OutputJax.NativeMML=MathJax.OutputJax({id:"NativeMML",version:"2.3",directory:MathJax.OutputJax.directory+"/NativeMML",extensionDir:MathJax.OutputJax.extensionDir+"/NativeMML",config:{matchFontHeight:true,scale:100,minScaleAdjust:50,styles:{"div.MathJax_MathML":{"text-align":"center",margin:".75em 0px"}}}});if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax.NativeMML.Register("jax/mml")}MathJax.OutputJax.NativeMML.loadComplete("config.js");
(function(c,g){var f="2.3";var a=MathJax.Hub.CombineConfig("MMLorHTML",{prefer:{MSIE:"MML",Firefox:"HTML",Opera:"HTML",Chrome:"HTML",Safari:"HTML",other:"HTML"}});var e={Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4};var b=(g.version==="0.0"||g.versionAtLeast(e[g]||0));var d=(g.isFirefox&&g.versionAtLeast("1.5"))||(g.isMSIE&&g.hasMathPlayer)||(g.isSafari&&g.versionAtLeast("5.0"))||(g.isOpera&&g.versionAtLeast("9.52"));c.Register.StartupHook("End Config",function(){var h=(a.prefer&&typeof(a.prefer)==="object"?a.prefer[MathJax.Hub.Browser]||a.prefer.other||"HTML":a.prefer);if(b||d){if(d&&(h==="MML"||!b)){if(MathJax.OutputJax.NativeMML){MathJax.OutputJax.NativeMML.Register("jax/mml")}else{c.config.jax.unshift("output/NativeMML")}c.Startup.signal.Post("NativeMML output selected")}else{if(MathJax.OutputJax["HTML-CSS"]){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}else{c.config.jax.unshift("output/HTML-CSS")}c.Startup.signal.Post("HTML-CSS output selected")}}else{c.PreProcess.disabled=true;c.prepareScripts.disabled=true;MathJax.Message.Set(["MathJaxNotSupported","Your browser does not support MathJax"],null,4000);c.Startup.signal.Post("MathJax not supported")}})})(MathJax.Hub,MathJax.Hub.Browser);MathJax.Ajax.loadComplete("[MathJax]/config/MMLorHTML.js");
MathJax.Extension.mml2jax={version:"2.3",config:{preview:"mathml"},MMLnamespace:"http://www.w3.org/1998/Math/MathML",PreProcess:function(e){if(!this.configured){this.config=MathJax.Hub.CombineConfig("mml2jax",this.config);if(this.config.Augment){MathJax.Hub.Insert(this,this.config.Augment)}this.InitBrowser();this.configured=true}if(typeof(e)==="string"){e=document.getElementById(e)}if(!e){e=document.body}var h=[];h.push.apply(h,e.getElementsByTagName("math"));if(e.getElementsByTagNameNS){h.push.apply(h,e.getElementsByTagNameNS(this.MMLnamespace,"math"))}var d,b;if(typeof(document.namespaces)!=="undefined"){try{for(d=0,b=document.namespaces.length;d<b;d++){var f=document.namespaces[d];if(f.urn===this.MMLnamespace){h.push.apply(h,e.getElementsByTagName(f.name+":math"))}}}catch(g){}}else{var c=document.getElementsByTagName("html")[0];if(c){for(d=0,b=c.attributes.length;d<b;d++){var a=c.attributes[d];if(a.nodeName.substr(0,6)==="xmlns:"&&a.nodeValue===this.MMLnamespace){h.push.apply(h,e.getElementsByTagName(a.nodeName.substr(6)+":math"))}}}}this.ProcessMathArray(h)},ProcessMathArray:function(c){var b,a=c.length;if(a){if(this.MathTagBug){for(b=0;b<a;b++){if(c[b].nodeName==="MATH"){this.ProcessMathFlattened(c[b])}else{this.ProcessMath(c[b])}}}else{for(b=0;b<a;b++){this.ProcessMath(c[b])}}}},ProcessMath:function(e){var d=e.parentNode;if(!d||d.className===MathJax.Hub.config.preRemoveClass){return}var a=document.createElement("script");a.type="math/mml";d.insertBefore(a,e);if(this.AttributeBug){var b=this.OuterHTML(e);if(this.CleanupHTML){b=b.replace(/<\?import .*?>/i,"").replace(/<\?xml:namespace .*?\/>/i,"");b=b.replace(/&nbsp;/g,"&#xA0;")}MathJax.HTML.setScript(a,b);d.removeChild(e)}else{var c=MathJax.HTML.Element("span");c.appendChild(e);MathJax.HTML.setScript(a,c.innerHTML)}if(this.config.preview!=="none"){this.createPreview(e,a)}},ProcessMathFlattened:function(f){var d=f.parentNode;if(!d||d.className===MathJax.Hub.config.preRemoveClass){return}var b=document.createElement("script");b.type="math/mml";d.insertBefore(b,f);var c="",e,a=f;while(f&&f.nodeName!=="/MATH"){e=f;f=f.nextSibling;c+=this.NodeHTML(e);e.parentNode.removeChild(e)}if(f&&f.nodeName==="/MATH"){f.parentNode.removeChild(f)}b.text=c+"</math>";if(this.config.preview!=="none"){this.createPreview(a,b)}},NodeHTML:function(e){var c,b,a;if(e.nodeName==="#text"){c=this.quoteHTML(e.nodeValue)}else{if(e.nodeName==="#comment"){c="<!--"+e.nodeValue+"-->"}else{c="<"+e.nodeName.toLowerCase();for(b=0,a=e.attributes.length;b<a;b++){var d=e.attributes[b];if(d.specified){c+=" "+d.nodeName.toLowerCase().replace(/xmlns:xmlns/,"xmlns")+"=";var f=d.nodeValue;if(f==null&&d.nodeName==="style"&&e.style){f=e.style.cssText}c+='"'+this.quoteHTML(f)+'"'}}c+=">";if(e.outerHTML!=null&&e.outerHTML.match(/(.<\/[A-Z]+>|\/>)$/)){for(b=0,a=e.childNodes.length;b<a;b++){c+=this.OuterHTML(e.childNodes[b])}c+="</"+e.nodeName.toLowerCase()+">"}}}return c},OuterHTML:function(d){if(d.nodeName.charAt(0)==="#"){return this.NodeHTML(d)}if(!this.AttributeBug){return d.outerHTML}var c=this.NodeHTML(d);for(var b=0,a=d.childNodes.length;b<a;b++){c+=this.OuterHTML(d.childNodes[b])}c+="</"+d.nodeName.toLowerCase()+">";return c},quoteHTML:function(a){if(a==null){a=""}return a.replace(/&/g,"&#x26;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\"/g,"&quot;")},createPreview:function(f,b){var g=this.config.preview;if(g==="none"){return}var a=false;if(g==="mathml"){a=true;if(this.MathTagBug){g="alttext"}else{g=f.cloneNode(false)}}if(g==="alttext"||g==="altimg"){a=true;var c=this.filterPreview(f.getAttribute("alttext"));if(g==="alttext"){if(c!=null){g=MathJax.HTML.TextNode(c)}else{g=null}}else{var h=f.getAttribute("altimg");if(h!=null){var e={width:f.getAttribute("altimg-width"),height:f.getAttribute("altimg-height")};g=MathJax.HTML.Element("img",{src:h,alt:c,style:e})}else{g=null}}}if(g){var d;if(a){d=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass});d.appendChild(g)}else{d=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass},g)}b.parentNode.insertBefore(d,b)}},filterPreview:function(a){return a},InitBrowser:function(){var b=MathJax.HTML.Element("span",{id:"<",className:"mathjax",innerHTML:"<math><mi>x</mi><mspace /></math>"});var a=b.outerHTML||"";this.AttributeBug=a!==""&&!(a.match(/id="&lt;"/)&&a.match(/class="mathjax"/)&&a.match(/<\/math>/));this.MathTagBug=b.childNodes.length>1;this.CleanupHTML=MathJax.Hub.Browser.isMSIE}};MathJax.Hub.Register.PreProcessor(["PreProcess",MathJax.Extension.mml2jax],5);MathJax.Ajax.loadComplete("[MathJax]/extensions/mml2jax.js");
(function(d,h,l,g,m,b,j){var q="2.3";var i=MathJax.Extension;var c=i.MathEvents={version:q};var k=d.config.menuSettings;var p={hover:500,frame:{x:3.5,y:5,bwidth:1,bcolor:"#A6D",hwidth:"15px",hcolor:"#83A"},button:{x:-4,y:-3,wx:-2,src:l.fileURL(b.imageDir+"/MenuArrow-15.png")},fadeinInc:0.2,fadeoutInc:0.05,fadeDelay:50,fadeoutStart:400,fadeoutDelay:15*1000,styles:{".MathJax_Hover_Frame":{"border-radius":".25em","-webkit-border-radius":".25em","-moz-border-radius":".25em","-khtml-border-radius":".25em","box-shadow":"0px 0px 15px #83A","-webkit-box-shadow":"0px 0px 15px #83A","-moz-box-shadow":"0px 0px 15px #83A","-khtml-box-shadow":"0px 0px 15px #83A",border:"1px solid #A6D ! important",display:"inline-block",position:"absolute"},".MathJax_Hover_Arrow":{position:"absolute",width:"15px",height:"11px",cursor:"pointer"}}};var n=c.Event={LEFTBUTTON:0,RIGHTBUTTON:2,MENUKEY:"altKey",Mousedown:function(r){return n.Handler(r,"Mousedown",this)},Mouseup:function(r){return n.Handler(r,"Mouseup",this)},Mousemove:function(r){return n.Handler(r,"Mousemove",this)},Mouseover:function(r){return n.Handler(r,"Mouseover",this)},Mouseout:function(r){return n.Handler(r,"Mouseout",this)},Click:function(r){return n.Handler(r,"Click",this)},DblClick:function(r){return n.Handler(r,"DblClick",this)},Menu:function(r){return n.Handler(r,"ContextMenu",this)},Handler:function(u,s,t){if(l.loadingMathMenu){return n.False(u)}var r=b[t.jaxID];if(!u){u=window.event}u.isContextMenu=(s==="ContextMenu");if(r[s]){return r[s](u,t)}if(i.MathZoom){return i.MathZoom.HandleEvent(u,s,t)}},False:function(r){if(!r){r=window.event}if(r){if(r.preventDefault){r.preventDefault()}if(r.stopPropagation){r.stopPropagation()}r.cancelBubble=true;r.returnValue=false}return false},ContextMenu:function(u,F,x){var C=b[F.jaxID],w=C.getJaxFromMath(F);var G=(C.config.showMathMenu!=null?C:d).config.showMathMenu;if(!G||(k.context!=="MathJax"&&!x)){return}if(c.msieEventBug){u=window.event||u}n.ClearSelection();f.ClearHoverTimer();if(w.hover){if(w.hover.remove){clearTimeout(w.hover.remove);delete w.hover.remove}w.hover.nofade=true}var v=MathJax.Menu;var H,E;if(v){if(v.loadingDomain){return n.False(u)}H=m.loadDomain("MathMenu");if(!H){v.jax=w;var s=v.menu.Find("Show Math As").menu;s.items[0].name=w.sourceMenuTitle;s.items[0].format=(w.sourceMenuFormat||"MathML");s.items[1].name=j[w.inputJax].sourceMenuTitle;var B=s.items[2];B.disabled=true;var r=B.menu.items;annotationList=MathJax.Hub.Config.semanticsAnnotations;for(var A=0,z=r.length;A<z;A++){var t=r[A].name[1];if(w.root&&w.root.getAnnotation(t)!==null){B.disabled=false;r[A].hidden=false}else{r[A].hidden=true}}var y=v.menu.Find("Math Settings","MathPlayer");y.hidden=!(w.outputJax==="NativeMML"&&d.Browser.hasMathPlayer);return v.menu.Post(u)}v.loadingDomain=true;E=function(){delete v.loadingDomain}}else{if(l.loadingMathMenu){return n.False(u)}l.loadingMathMenu=true;H=l.Require("[MathJax]/extensions/MathMenu.js");E=function(){delete l.loadingMathMenu;if(!MathJax.Menu){MathJax.Menu={}}}}var D={pageX:u.pageX,pageY:u.pageY,clientX:u.clientX,clientY:u.clientY};g.Queue(H,E,["ContextMenu",n,D,F,x]);return n.False(u)},AltContextMenu:function(t,s){var u=b[s.jaxID];var r=(u.config.showMathMenu!=null?u:d).config.showMathMenu;if(r){r=(u.config.showMathMenuMSIE!=null?u:d).config.showMathMenuMSIE;if(k.context==="MathJax"&&!k.mpContext&&r){if(!c.noContextMenuBug||t.button!==n.RIGHTBUTTON){return}}else{if(!t[n.MENUKEY]||t.button!==n.LEFTBUTTON){return}}return u.ContextMenu(t,s,true)}},ClearSelection:function(){if(c.safariContextMenuBug){setTimeout("window.getSelection().empty()",0)}if(document.selection){setTimeout("document.selection.empty()",0)}},getBBox:function(t){t.appendChild(c.topImg);var s=c.topImg.offsetTop,u=t.offsetHeight-s,r=t.offsetWidth;t.removeChild(c.topImg);return{w:r,h:s,d:u}}};var f=c.Hover={Mouseover:function(t,s){if(k.discoverable||k.zoom==="Hover"){var v=t.fromElement||t.relatedTarget,u=t.toElement||t.target;if(v&&u&&(v.isMathJax!=u.isMathJax||d.getJaxFor(v)!==d.getJaxFor(u))){var r=this.getJaxFromMath(s);if(r.hover){f.ReHover(r)}else{f.HoverTimer(r,s)}return n.False(t)}}},Mouseout:function(t,s){if(k.discoverable||k.zoom==="Hover"){var v=t.fromElement||t.relatedTarget,u=t.toElement||t.target;if(v&&u&&(v.isMathJax!=u.isMathJax||d.getJaxFor(v)!==d.getJaxFor(u))){var r=this.getJaxFromMath(s);if(r.hover){f.UnHover(r)}else{f.ClearHoverTimer()}return n.False(t)}}},Mousemove:function(t,s){if(k.discoverable||k.zoom==="Hover"){var r=this.getJaxFromMath(s);if(r.hover){return}if(f.lastX==t.clientX&&f.lastY==t.clientY){return}f.lastX=t.clientX;f.lastY=t.clientY;f.HoverTimer(r,s);return n.False(t)}},HoverTimer:function(r,s){this.ClearHoverTimer();this.hoverTimer=setTimeout(g(["Hover",this,r,s]),p.hover)},ClearHoverTimer:function(){if(this.hoverTimer){clearTimeout(this.hoverTimer);delete this.hoverTimer}},Hover:function(r,v){if(i.MathZoom&&i.MathZoom.Hover({},v)){return}var u=b[r.outputJax],w=u.getHoverSpan(r,v),z=u.getHoverBBox(r,w,v),x=(u.config.showMathMenu!=null?u:d).config.showMathMenu;var B=p.frame.x,A=p.frame.y,y=p.frame.bwidth;if(c.msieBorderWidthBug){y=0}r.hover={opacity:0,id:r.inputID+"-Hover"};var s=h.Element("span",{id:r.hover.id,isMathJax:true,style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{className:"MathJax_Hover_Frame",isMathJax:true,style:{display:"inline-block",position:"absolute",top:this.Px(-z.h-A-y-(z.y||0)),left:this.Px(-B-y+(z.x||0)),width:this.Px(z.w+2*B),height:this.Px(z.h+z.d+2*A),opacity:0,filter:"alpha(opacity=0)"}}]]);var t=h.Element("span",{isMathJax:true,id:r.hover.id+"Menu",style:{display:"inline-block","z-index":1,width:0,height:0,position:"relative"}},[["img",{className:"MathJax_Hover_Arrow",isMathJax:true,math:v,src:p.button.src,onclick:this.HoverMenu,jax:u.id,style:{left:this.Px(z.w+B+y+(z.x||0)+p.button.x),top:this.Px(-z.h-A-y-(z.y||0)-p.button.y),opacity:0,filter:"alpha(opacity=0)"}}]]);if(z.width){s.style.width=t.style.width=z.width;s.style.marginRight=t.style.marginRight="-"+z.width;s.firstChild.style.width=z.width;t.firstChild.style.left="";t.firstChild.style.right=this.Px(p.button.wx)}w.parentNode.insertBefore(s,w);if(x){w.parentNode.insertBefore(t,w)}if(w.style){w.style.position="relative"}this.ReHover(r)},ReHover:function(r){if(r.hover.remove){clearTimeout(r.hover.remove)}r.hover.remove=setTimeout(g(["UnHover",this,r]),p.fadeoutDelay);this.HoverFadeTimer(r,p.fadeinInc)},UnHover:function(r){if(!r.hover.nofade){this.HoverFadeTimer(r,-p.fadeoutInc,p.fadeoutStart)}},HoverFade:function(r){delete r.hover.timer;r.hover.opacity=Math.max(0,Math.min(1,r.hover.opacity+r.hover.inc));r.hover.opacity=Math.floor(1000*r.hover.opacity)/1000;var t=document.getElementById(r.hover.id),s=document.getElementById(r.hover.id+"Menu");t.firstChild.style.opacity=r.hover.opacity;t.firstChild.style.filter="alpha(opacity="+Math.floor(100*r.hover.opacity)+")";if(s){s.firstChild.style.opacity=r.hover.opacity;s.firstChild.style.filter=t.style.filter}if(r.hover.opacity===1){return}if(r.hover.opacity>0){this.HoverFadeTimer(r,r.hover.inc);return}t.parentNode.removeChild(t);if(s){s.parentNode.removeChild(s)}if(r.hover.remove){clearTimeout(r.hover.remove)}delete r.hover},HoverFadeTimer:function(r,t,s){r.hover.inc=t;if(!r.hover.timer){r.hover.timer=setTimeout(g(["HoverFade",this,r]),(s||p.fadeDelay))}},HoverMenu:function(r){if(!r){r=window.event}return b[this.jax].ContextMenu(r,this.math,true)},ClearHover:function(r){if(r.hover.remove){clearTimeout(r.hover.remove)}if(r.hover.timer){clearTimeout(r.hover.timer)}f.ClearHoverTimer();delete r.hover},Px:function(r){if(Math.abs(r)<0.006){return"0px"}return r.toFixed(2).replace(/\.?0+$/,"")+"px"},getImages:function(){var r=new Image();r.src=p.button.src}};var a=c.Touch={last:0,delay:500,start:function(s){var r=new Date().getTime();var t=(r-a.last<a.delay&&a.up);a.last=r;a.up=false;if(t){a.timeout=setTimeout(a.menu,a.delay,s,this);s.preventDefault()}},end:function(s){var r=new Date().getTime();a.up=(r-a.last<a.delay);if(a.timeout){clearTimeout(a.timeout);delete a.timeout;a.last=0;a.up=false;s.preventDefault();return n.Handler((s.touches[0]||s.touch),"DblClick",this)}},menu:function(s,r){delete a.timeout;a.last=0;a.up=false;return n.Handler((s.touches[0]||s.touch),"ContextMenu",r)}};if(d.Browser.isMobile){var o=p.styles[".MathJax_Hover_Arrow"];o.width="25px";o.height="18px";p.button.x=-6}d.Browser.Select({MSIE:function(r){var t=(document.documentMode||0);var s=r.versionAtLeast("8.0");c.msieBorderWidthBug=(document.compatMode==="BackCompat");c.msieEventBug=r.isIE9;c.msieAlignBug=(!s||t<8);if(t<9){n.LEFTBUTTON=1}},Safari:function(r){c.safariContextMenuBug=true},Opera:function(r){c.operaPositionBug=true},Konqueror:function(r){c.noContextMenuBug=true}});c.topImg=(c.msieAlignBug?h.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):h.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(c.operaPositionBug){c.topImg.style.border="1px solid"}c.config=p=d.CombineConfig("MathEvents",p);var e=function(){var r=p.styles[".MathJax_Hover_Frame"];r.border=p.frame.bwidth+"px solid "+p.frame.bcolor+" ! important";r["box-shadow"]=r["-webkit-box-shadow"]=r["-moz-box-shadow"]=r["-khtml-box-shadow"]="0px 0px "+p.frame.hwidth+" "+p.frame.hcolor};g.Queue(d.Register.StartupHook("End Config",{}),[e],["getImages",f],["Styles",l,p.styles],["Post",d.Startup.signal,"MathEvents Ready"],["loadComplete",l,"[MathJax]/extensions/MathEvents.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.Callback,MathJax.Localization,MathJax.OutputJax,MathJax.InputJax);
(function(a,d,f,c,j){var k="2.3";var i=a.CombineConfig("MathZoom",{styles:{"#MathJax_Zoom":{position:"absolute","background-color":"#F0F0F0",overflow:"auto",display:"block","z-index":301,padding:".5em",border:"1px solid black",margin:0,"font-weight":"normal","font-style":"normal","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","box-shadow":"5px 5px 15px #AAAAAA","-webkit-box-shadow":"5px 5px 15px #AAAAAA","-moz-box-shadow":"5px 5px 15px #AAAAAA","-khtml-box-shadow":"5px 5px 15px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_ZoomOverlay":{position:"absolute",left:0,top:0,"z-index":300,display:"inline-block",width:"100%",height:"100%",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"},"#MathJax_ZoomFrame":{position:"relative",display:"inline-block",height:0,width:0},"#MathJax_ZoomEventTrap":{position:"absolute",left:0,top:0,"z-index":302,display:"inline-block",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"}}});var e,b,g;MathJax.Hub.Register.StartupHook("MathEvents Ready",function(){g=MathJax.Extension.MathEvents.Event;e=MathJax.Extension.MathEvents.Event.False;b=MathJax.Extension.MathEvents.Hover});var h=MathJax.Extension.MathZoom={version:k,settings:a.config.menuSettings,scrollSize:18,HandleEvent:function(n,l,m){if(h.settings.CTRL&&!n.ctrlKey){return true}if(h.settings.ALT&&!n.altKey){return true}if(h.settings.CMD&&!n.metaKey){return true}if(h.settings.Shift&&!n.shiftKey){return true}if(!h[l]){return true}return h[l](n,m)},Click:function(m,l){if(this.settings.zoom==="Click"){return this.Zoom(m,l)}},DblClick:function(m,l){if(this.settings.zoom==="Double-Click"||this.settings.zoom==="DoubleClick"){return this.Zoom(m,l)}},Hover:function(m,l){if(this.settings.zoom==="Hover"){this.Zoom(m,l);return true}return false},Zoom:function(n,s){this.Remove();b.ClearHoverTimer();g.ClearSelection();var q=MathJax.OutputJax[s.jaxID];var o=q.getJaxFromMath(s);if(o.hover){b.UnHover(o)}var l=Math.floor(0.85*document.body.clientWidth),r=Math.floor(0.85*Math.max(document.body.clientHeight,document.documentElement.clientHeight));var m=d.Element("span",{id:"MathJax_ZoomFrame"},[["span",{id:"MathJax_ZoomOverlay",onmousedown:this.Remove}],["span",{id:"MathJax_Zoom",onclick:this.Remove,style:{visibility:"hidden",fontSize:this.settings.zscale,"max-width":l+"px","max-height":r+"px"}},[["span",{style:{display:"inline-block","white-space":"nowrap"}}]]]]);var x=m.lastChild,u=x.firstChild,p=m.firstChild;s.parentNode.insertBefore(m,s);s.parentNode.insertBefore(s,m);if(u.addEventListener){u.addEventListener("mousedown",this.Remove,true)}if(this.msieTrapEventBug){var w=d.Element("span",{id:"MathJax_ZoomEventTrap",onmousedown:this.Remove});m.insertBefore(w,x)}if(this.msieZIndexBug){var t=d.addElement(document.body,"img",{src:"about:blank",id:"MathJax_ZoomTracker",width:0,height:0,style:{width:0,height:0,position:"relative"}});m.style.position="relative";m.style.zIndex=i.styles["#MathJax_ZoomOverlay"]["z-index"];m=t}var v=q.Zoom(o,u,s,l,r);if(this.msiePositionBug){if(this.msieSizeBug){x.style.height=v.zH+"px";x.style.width=v.zW+"px"}if(x.offsetHeight>r){x.style.height=r+"px";x.style.width=(v.zW+this.scrollSize)+"px"}if(x.offsetWidth>l){x.style.width=l+"px";x.style.height=(v.zH+this.scrollSize)+"px"}}if(this.operaPositionBug){x.style.width=Math.min(l,v.zW)+"px"}if(x.offsetWidth&&x.offsetWidth<l&&x.offsetHeight<r){x.style.overflow="visible"}this.Position(x,v);if(this.msieTrapEventBug){w.style.height=x.clientHeight+"px";w.style.width=x.clientWidth+"px";w.style.left=(parseFloat(x.style.left)+x.clientLeft)+"px";w.style.top=(parseFloat(x.style.top)+x.clientTop)+"px"}x.style.visibility="";if(this.settings.zoom==="Hover"){p.onmouseover=this.Remove}if(window.addEventListener){addEventListener("resize",this.Resize,false)}else{if(window.attachEvent){attachEvent("onresize",this.Resize)}else{this.onresize=window.onresize;window.onresize=this.Resize}}a.signal.Post(["math zoomed",o]);return e(n)},Position:function(p,r){var q=this.Resize(),m=q.x,s=q.y,l=r.mW;var o=-l-Math.floor((p.offsetWidth-l)/2),n=r.Y;p.style.left=Math.max(o,10-m)+"px";p.style.top=Math.max(n,10-s)+"px";if(!h.msiePositionBug){h.SetWH()}},Resize:function(m){if(h.onresize){h.onresize(m)}var r=document.getElementById("MathJax_ZoomFrame"),l=document.getElementById("MathJax_ZoomOverlay");var o=h.getXY(r);var n=r.parentNode,q=h.getOverflow(n);while(n.parentNode&&n!==document.body&&q==="visible"){n=n.parentNode;q=h.getOverflow(n)}if(q!=="visible"){l.scroll_parent=n;var p=h.getXY(n);o.x-=p.x;o.y-=p.y;p=h.getBorder(n);o.x-=p.x;o.y-=p.y}l.style.left=(-o.x)+"px";l.style.top=(-o.y)+"px";if(h.msiePositionBug){setTimeout(h.SetWH,0)}else{h.SetWH()}return o},SetWH:function(){var l=document.getElementById("MathJax_ZoomOverlay");l.style.width=l.style.height="1px";var m=l.scroll_parent||document.documentElement||document.body;l.style.width=m.scrollWidth+"px";l.style.height=Math.max(m.clientHeight,m.scrollHeight)+"px"},getOverflow:(window.getComputedStyle?function(l){return getComputedStyle(l).overflow}:function(l){return(l.currentStyle||{overflow:"visible"}).overflow}),getBorder:function(o){var m={thin:1,medium:2,thick:3};var n=(window.getComputedStyle?getComputedStyle(o):(o.currentStyle||{borderLeftWidth:0,borderTopWidth:0}));var l=n.borderLeftWidth,p=n.borderTopWidth;if(m[l]){l=m[l]}else{l=parseInt(l)}if(m[p]){p=m[p]}else{p=parseInt(p)}return{x:l,y:p}},getXY:function(o){var l=0,n=0,m;m=o;while(m.offsetParent){l+=m.offsetLeft;m=m.offsetParent}if(h.operaPositionBug){o.style.border="1px solid"}m=o;while(m.offsetParent){n+=m.offsetTop;m=m.offsetParent}if(h.operaPositionBug){o.style.border=""}return{x:l,y:n}},Remove:function(n){var p=document.getElementById("MathJax_ZoomFrame");if(p){var o=MathJax.OutputJax[p.previousSibling.jaxID];var l=o.getJaxFromMath(p.previousSibling);a.signal.Post(["math unzoomed",l]);p.parentNode.removeChild(p);p=document.getElementById("MathJax_ZoomTracker");if(p){p.parentNode.removeChild(p)}if(h.operaRefreshBug){var m=d.addElement(document.body,"div",{style:{position:"fixed",left:0,top:0,width:"100%",height:"100%",backgroundColor:"white",opacity:0},id:"MathJax_OperaDiv"});document.body.removeChild(m)}if(window.removeEventListener){removeEventListener("resize",h.Resize,false)}else{if(window.detachEvent){detachEvent("onresize",h.Resize)}else{window.onresize=h.onresize;delete h.onresize}}}return e(n)}};a.Browser.Select({MSIE:function(l){var n=(document.documentMode||0);var m=(n>=9);h.msiePositionBug=!m;h.msieSizeBug=l.versionAtLeast("7.0")&&(!document.documentMode||n===7||n===8);h.msieZIndexBug=(n<=7);h.msieInlineBlockAlignBug=(n<=7);h.msieTrapEventBug=!window.addEventListener;if(document.compatMode==="BackCompat"){h.scrollSize=52}if(m){delete i.styles["#MathJax_Zoom"].filter}},Opera:function(l){h.operaPositionBug=true;h.operaRefreshBug=true}});h.topImg=(h.msieInlineBlockAlignBug?d.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):d.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(h.operaPositionBug||h.msieTopBug){h.topImg.style.border="1px solid"}MathJax.Callback.Queue(["StartupHook",MathJax.Hub.Register,"Begin Styles",{}],["Styles",f,i.styles],["Post",a.Startup.signal,"MathZoom Ready"],["loadComplete",f,"[MathJax]/extensions/MathZoom.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax["HTML-CSS"],MathJax.OutputJax.NativeMML);
(function(c,g,k,f,b){var q="2.3";var j=MathJax.Callback.Signal("menu");MathJax.Extension.MathMenu={version:q,signal:j};var o=function(r){return MathJax.Localization._.apply(MathJax.Localization,[["MathMenu",r]].concat([].slice.call(arguments,1)))};var n=c.Browser.isPC,l=c.Browser.isMSIE,e=((document.documentMode||0)>8);var i=(n?null:"5px");var p=c.CombineConfig("MathMenu",{delay:150,closeImg:k.fileURL(b.imageDir+"/CloseX-31.png"),showRenderer:true,showMathPlayer:true,showFontMenu:false,showContext:false,showDiscoverable:false,showLocale:true,showLocaleURL:false,semanticsAnnotations:{TeX:["TeX","LaTeX","application/x-tex"],StarMath:["StarMath 5.0"],Maple:["Maple"],ContentMathML:["MathML-Content","application/mathml-content+xml"],OpenMath:["OpenMath"]},windowSettings:{status:"no",toolbar:"no",locationbar:"no",menubar:"no",directories:"no",personalbar:"no",resizable:"yes",scrollbars:"yes",width:400,height:300,left:Math.round((screen.width-400)/2),top:Math.round((screen.height-300)/3)},styles:{"#MathJax_About":{position:"fixed",left:"50%",width:"auto","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",color:"black",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_Menu":{position:"absolute","background-color":"white",color:"black",width:"auto",padding:(n?"2px":"5px 0px"),border:"1px solid #CCCCCC",margin:0,cursor:"default",font:"menu","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":i,"-webkit-border-radius":i,"-moz-border-radius":i,"-khtml-border-radius":i,"box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_MenuItem":{padding:(n?"2px 2em":"1px 2em"),background:"transparent"},".MathJax_MenuArrow":{position:"absolute",right:".5em",color:"#666666","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuActive .MathJax_MenuArrow":{color:"white"},".MathJax_MenuCheck":{position:"absolute",left:".7em","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuRadioCheck":{position:"absolute",left:(n?"1em":".7em")},".MathJax_MenuLabel":{padding:(n?"2px 2em 4px 1.33em":"1px 2em 3px 1.33em"),"font-style":"italic"},".MathJax_MenuRule":{"border-top":(n?"1px solid #CCCCCC":"1px solid #DDDDDD"),margin:(n?"4px 1px 0px":"4px 3px")},".MathJax_MenuDisabled":{color:"GrayText"},".MathJax_MenuActive":{"background-color":(n?"Highlight":"#606872"),color:(n?"HighlightText":"white")},".MathJax_Menu_Close":{position:"absolute",width:"31px",height:"31px",top:"-15px",left:"-15px"}}});var h,d;c.Register.StartupHook("MathEvents Ready",function(){h=MathJax.Extension.MathEvents.Event.False;d=MathJax.Extension.MathEvents.Hover});var a=MathJax.Menu=MathJax.Object.Subclass({version:q,items:[],posted:false,title:null,margin:5,Init:function(r){this.items=[].slice.call(arguments,0)},With:function(r){if(r){c.Insert(this,r)}return this},Post:function(s,B){if(!s){s=window.event}var r=document.getElementById("MathJax_MenuFrame");if(!r){r=a.Background(this);delete m.lastItem;delete m.lastMenu;delete a.skipUp;j.Post(["post",a.jax])}var t=g.addElement(r,"div",{onmouseup:a.Mouseup,ondblclick:h,ondragstart:h,onselectstart:h,oncontextmenu:h,menuItem:this,className:"MathJax_Menu"});MathJax.Localization.setCSS(t);for(var v=0,u=this.items.length;v<u;v++){this.items[v].Create(t)}if(a.isMobile){g.addElement(t,"span",{className:"MathJax_Menu_Close",menu:B,ontouchstart:a.Close,ontouchend:h,onmousedown:a.Close,onmouseup:h},[["img",{src:p.closeImg,style:{width:"100%",height:"100%"}}]])}this.posted=true;t.style.width=(t.offsetWidth+2)+"px";var A=s.pageX,z=s.pageY;if(!A&&!z){A=s.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;z=s.clientY+document.body.scrollTop+document.documentElement.scrollTop}if(!B){if(A+t.offsetWidth>document.body.offsetWidth-this.margin){A=document.body.offsetWidth-t.offsetWidth-this.margin}if(a.isMobile){A=Math.max(5,A-Math.floor(t.offsetWidth/2));z-=20}a.skipUp=s.isContextMenu}else{var w="left",C=B.offsetWidth;A=(a.isMobile?30:C-2);z=0;while(B&&B!==r){A+=B.offsetLeft;z+=B.offsetTop;B=B.parentNode}if(A+t.offsetWidth>document.body.offsetWidth-this.margin&&!a.isMobile){w="right";A=Math.max(this.margin,A-C-t.offsetWidth+6)}if(!n){t.style["borderRadiusTop"+w]=0;t.style["WebkitBorderRadiusTop"+w]=0;t.style["MozBorderRadiusTop"+w]=0;t.style["KhtmlBorderRadiusTop"+w]=0}}t.style.left=A+"px";t.style.top=z+"px";if(document.selection&&document.selection.empty){document.selection.empty()}return h(s)},Remove:function(r,s){j.Post(["unpost",a.jax]);var t=document.getElementById("MathJax_MenuFrame");if(t){t.parentNode.removeChild(t);if(this.msieFixedPositionBug){detachEvent("onresize",a.Resize)}}if(a.jax.hover){delete a.jax.hover.nofade;d.UnHover(a.jax)}return h(r)},Find:function(r){return this.FindN(1,r,[].slice.call(arguments,1))},FindId:function(r){return this.FindN(0,r,[].slice.call(arguments,1))},FindN:function(v,s,u){for(var t=0,r=this.items.length;t<r;t++){if(this.items[t].name[v]===s){if(u.length){if(!this.items[t].menu){return null}return this.items[t].menu.FindN(v,u[0],u.slice(1))}return this.items[t]}}return null},IndexOf:function(r){return this.IndexOfN(1,r)},IndexOfId:function(r){return this.IndexOfN(0,r)},IndexOfN:function(u,s){for(var t=0,r=this.items.length;t<r;t++){if(this.items[t].name[u]===s){return t}}return null}},{config:p,div:null,Close:function(r){return a.Event(r,this.menu||this.parentNode,(this.menu?"Touchend":"Remove"))},Remove:function(r){return a.Event(r,this,"Remove")},Mouseover:function(r){return a.Event(r,this,"Mouseover")},Mouseout:function(r){return a.Event(r,this,"Mouseout")},Mousedown:function(r){return a.Event(r,this,"Mousedown")},Mouseup:function(r){return a.Event(r,this,"Mouseup")},Touchstart:function(r){return a.Event(r,this,"Touchstart")},Touchend:function(r){return a.Event(r,this,"Touchend")},Event:function(t,v,r,u){if(a.skipMouseover&&r==="Mouseover"&&!u){return h(t)}if(a.skipUp){if(r.match(/Mouseup|Touchend/)){delete a.skipUp;return h(t)}if(r==="Touchstart"||(r==="Mousedown"&&!a.skipMousedown)){delete a.skipUp}}if(!t){t=window.event}var s=v.menuItem;if(s&&s[r]){return s[r](t,v)}return null},BGSTYLE:{position:"absolute",left:0,top:0,"z-index":200,width:"100%",height:"100%",border:0,padding:0,margin:0},Background:function(s){var t=g.addElement(document.body,"div",{style:this.BGSTYLE,id:"MathJax_MenuFrame"},[["div",{style:this.BGSTYLE,menuItem:s,onmousedown:this.Remove}]]);var r=t.firstChild;if(a.msieBackgroundBug){r.style.backgroundColor="white";r.style.filter="alpha(opacity=0)"}if(a.msieFixedPositionBug){t.width=t.height=0;this.Resize();attachEvent("onresize",this.Resize)}else{r.style.position="fixed"}return t},Resize:function(){setTimeout(a.SetWH,0)},SetWH:function(){var r=document.getElementById("MathJax_MenuFrame");if(r){r=r.firstChild;r.style.width=r.style.height="1px";r.style.width=document.body.scrollWidth+"px";r.style.height=document.body.scrollHeight+"px"}},saveCookie:function(){g.Cookie.Set("menu",this.cookie)},getCookie:function(){this.cookie=g.Cookie.Get("menu")},getImages:function(){if(a.isMobile){var r=new Image();r.src=p.closeImg}}});var m=a.ITEM=MathJax.Object.Subclass({name:"",Create:function(s){if(!this.hidden){var r={onmouseover:a.Mouseover,onmouseout:a.Mouseout,onmouseup:a.Mouseup,onmousedown:a.Mousedown,ondragstart:h,onselectstart:h,onselectend:h,ontouchstart:a.Touchstart,ontouchend:a.Touchend,className:"MathJax_MenuItem",menuItem:this};if(this.disabled){r.className+=" MathJax_MenuDisabled"}g.addElement(s,"div",r,this.Label(r,s))}},Name:function(){return o(this.name[0],this.name[1])},Mouseover:function(v,x){if(!this.disabled){this.Activate(x)}if(!this.menu||!this.menu.posted){var w=document.getElementById("MathJax_MenuFrame").childNodes,s=x.parentNode.childNodes;for(var t=0,r=s.length;t<r;t++){var u=s[t].menuItem;if(u&&u.menu&&u.menu.posted){u.Deactivate(s[t])}}r=w.length-1;while(r>=0&&x.parentNode.menuItem!==w[r].menuItem){w[r].menuItem.posted=false;w[r].parentNode.removeChild(w[r]);r--}if(this.Timer&&!a.isMobile){this.Timer(v,x)}}},Mouseout:function(r,s){if(!this.menu||!this.menu.posted){this.Deactivate(s)}if(this.timer){clearTimeout(this.timer);delete this.timer}},Mouseup:function(r,s){return this.Remove(r,s)},Touchstart:function(r,s){return this.TouchEvent(r,s,"Mousedown")},Touchend:function(r,s){return this.TouchEvent(r,s,"Mouseup")},TouchEvent:function(s,t,r){if(this!==m.lastItem){if(m.lastMenu){a.Event(s,m.lastMenu,"Mouseout")}a.Event(s,t,"Mouseover",true);m.lastItem=this;m.lastMenu=t}if(this.nativeTouch){return null}a.Event(s,t,r);return false},Remove:function(r,s){s=s.parentNode.menuItem;return s.Remove(r,s)},Activate:function(r){this.Deactivate(r);r.className+=" MathJax_MenuActive"},Deactivate:function(r){r.className=r.className.replace(/ MathJax_MenuActive/,"")},With:function(r){if(r){c.Insert(this,r)}return this}});a.ITEM.COMMAND=a.ITEM.Subclass({action:function(){},Init:function(r,t,s){if(!(r instanceof Array)){r=[r,r]}this.name=r;this.action=t;this.With(s)},Label:function(r,s){return[this.Name()]},Mouseup:function(r,s){if(!this.disabled){this.Remove(r,s);j.Post(["command",this]);this.action.call(this,r)}return h(r)}});a.ITEM.SUBMENU=a.ITEM.Subclass({menu:null,marker:(n&&!c.Browser.isSafari?"\u25B6":"\u25B8"),Init:function(r,t){if(!(r instanceof Array)){r=[r,r]}this.name=r;var s=1;if(!(t instanceof a.ITEM)){this.With(t),s++}this.menu=a.apply(a,[].slice.call(arguments,s))},Label:function(r,s){this.menu.posted=false;return[this.Name()+" ",["span",{className:"MathJax_MenuArrow"},[this.marker]]]},Timer:function(r,s){if(this.timer){clearTimeout(this.timer)}r={clientX:r.clientX,clientY:r.clientY};this.timer=setTimeout(f(["Mouseup",this,r,s]),p.delay)},Touchend:function(s,u){var t=this.menu.posted;var r=this.SUPER(arguments).Touchend.apply(this,arguments);if(t){this.Deactivate(u);delete m.lastItem;delete m.lastMenu}return r},Mouseup:function(s,u){if(!this.disabled){if(!this.menu.posted){if(this.timer){clearTimeout(this.timer);delete this.timer}this.menu.Post(s,u)}else{var t=document.getElementById("MathJax_MenuFrame").childNodes,r=t.length-1;while(r>=0){var v=t[r];v.menuItem.posted=false;v.parentNode.removeChild(v);if(v.menuItem===this.menu){break}r--}}}return h(s)}});a.ITEM.RADIO=a.ITEM.Subclass({variable:null,marker:(n?"\u25CF":"\u2713"),Init:function(s,r,t){if(!(s instanceof Array)){s=[s,s]}this.name=s;this.variable=r;this.With(t);if(this.value==null){this.value=this.name[0]}},Label:function(s,t){var r={className:"MathJax_MenuRadioCheck"};if(p.settings[this.variable]!==this.value){r={style:{display:"none"}}}return[["span",r,[this.marker]]," "+this.Name()]},Mouseup:function(u,v){if(!this.disabled){var w=v.parentNode.childNodes;for(var s=0,r=w.length;s<r;s++){var t=w[s].menuItem;if(t&&t.variable===this.variable){w[s].firstChild.style.display="none"}}v.firstChild.display="";p.settings[this.variable]=this.value;a.cookie[this.variable]=p.settings[this.variable];a.saveCookie();j.Post(["radio button",this])}this.Remove(u,v);if(this.action&&!this.disabled){this.action.call(a,this)}return h(u)}});a.ITEM.CHECKBOX=a.ITEM.Subclass({variable:null,marker:"\u2713",Init:function(s,r,t){if(!(s instanceof Array)){s=[s,s]}this.name=s;this.variable=r;this.With(t)},Label:function(s,t){var r={className:"MathJax_MenuCheck"};if(!p.settings[this.variable]){r={style:{display:"none"}}}return[["span",r,[this.marker]]," "+this.Name()]},Mouseup:function(r,s){if(!this.disabled){s.firstChild.display=(p.settings[this.variable]?"none":"");p.settings[this.variable]=!p.settings[this.variable];a.cookie[this.variable]=p.settings[this.variable];a.saveCookie();j.Post(["checkbox",this])}this.Remove(r,s);if(this.action&&!this.disabled){this.action.call(a,this)}return h(r)}});a.ITEM.LABEL=a.ITEM.Subclass({Init:function(r,s){if(!(r instanceof Array)){r=[r,r]}this.name=r;this.With(s)},Label:function(r,s){delete r.onmouseover,delete r.onmouseout;delete r.onmousedown;r.className+=" MathJax_MenuLabel";return[this.Name()]}});a.ITEM.RULE=a.ITEM.Subclass({Label:function(r,s){delete r.onmouseover,delete r.onmouseout;delete r.onmousedown;r.className+=" MathJax_MenuRule";return null}});a.About=function(){var t=b["HTML-CSS"]||{};var s=(t.imgFonts?"image":(t.fontInUse?(t.webFonts?"web":"local")+" "+t.fontInUse:(b.SVG?"web SVG":"generic")))+" fonts";var x=(!t.webFonts||t.imgFonts?null:t.allowWebFonts.replace(/otf/,"woff or otf")+" fonts");var r=["MathJax.js v"+MathJax.fileversion,["br"]];r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(r,MathJax.InputJax,["InputJax","%1 Input Jax v%2"]);a.About.GetJax(r,MathJax.OutputJax,["OutputJax","%1 Output Jax v%2"]);a.About.GetJax(r,MathJax.ElementJax,["ElementJax","%1 Element Jax v%2"]);r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(r,MathJax.Extension,["Extension","%1 Extension v%2"],true);r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}],["center",{},[c.Browser+" v"+c.Browser.version+(x?" \u2014 "+o(x.replace(/ /g,""),x):"")]]);a.About.div=a.Background(a.About);var v=g.addElement(a.About.div,"div",{id:"MathJax_About"},[["b",{style:{fontSize:"120%"}},["MathJax"]]," v"+MathJax.version,["br"],o(s.replace(/ /g,""),"using "+s),["br"],["br"],["span",{style:{display:"inline-block","text-align":"left","font-size":"80%","max-height":"20em",overflow:"auto","background-color":"#E4E4E4",padding:".4em .6em",border:"1px inset"}},r],["br"],["br"],["a",{href:"http://www.mathjax.org/"},["www.mathjax.org"]],["img",{src:p.closeImg,style:{width:"21px",height:"21px",position:"absolute",top:".2em",right:".2em"},onclick:a.About.Remove}]]);MathJax.Localization.setCSS(v);var w=(document.documentElement||{});var u=window.innerHeight||w.clientHeight||w.scrollHeight||0;if(a.prototype.msieAboutBug){v.style.width="20em";v.style.position="absolute";v.style.left=Math.floor((document.documentElement.scrollWidth-v.offsetWidth)/2)+"px";v.style.top=(Math.floor((u-v.offsetHeight)/3)+document.body.scrollTop)+"px"}else{v.style.marginLeft=Math.floor(-v.offsetWidth/2)+"px";v.style.top=Math.floor((u-v.offsetHeight)/3)+"px"}};a.About.Remove=function(r){if(a.About.div){document.body.removeChild(a.About.div);delete a.About.div}};a.About.GetJax=function(s,x,v,u){var w=[];for(var y in x){if(x.hasOwnProperty(y)&&x[y]){if((u&&x[y].version)||(x[y].isa&&x[y].isa(x))){w.push(o(v[0],v[1],(x[y].id||y),x[y].version))}}}w.sort();for(var t=0,r=w.length;t<r;t++){s.push(w[t],["br"])}return s};a.Help=function(){k.Require("[MathJax]/extensions/HelpDialog.js",function(){MathJax.Extension.Help.Dialog()})};a.ShowSource=function(v){if(!v){v=window.event}var u={screenX:v.screenX,screenY:v.screenY};if(!a.jax){return}if(this.format==="MathML"){var s=MathJax.ElementJax.mml;if(s&&typeof(s.mbase.prototype.toMathML)!=="undefined"){try{a.ShowSource.Text(a.jax.root.toMathML(),v)}catch(t){if(!t.restart){throw t}f.After([this,a.ShowSource,u],t.restart)}}else{if(!k.loadingToMathML){k.loadingToMathML=true;a.ShowSource.Window(v);f.Queue(k.Require("[MathJax]/extensions/toMathML.js"),function(){delete k.loadingToMathML;if(!s.mbase.prototype.toMathML){s.mbase.prototype.toMathML=function(){}}},[this,a.ShowSource,u]);return}}}else{if(this.format==="Error"){a.ShowSource.Text(a.jax.errorText,v)}else{if(p.semanticsAnnotations[this.format]){var r=a.jax.root.getAnnotation(this.format);if(r.data[0]){a.ShowSource.Text(r.data[0].toString())}}else{if(a.jax.originalText==null){alert(o("NoOriginalForm","No original form available"));return}a.ShowSource.Text(a.jax.originalText,v)}}}};a.ShowSource.Window=function(s){if(!a.ShowSource.w){var t=[],r=p.windowSettings;for(var u in r){if(r.hasOwnProperty(u)){t.push(u+"="+r[u])}}a.ShowSource.w=window.open("","_blank",t.join(","))}return a.ShowSource.w};a.ShowSource.Text=function(v,t){var r=a.ShowSource.Window(t);delete a.ShowSource.w;v=v.replace(/^\s*/,"").replace(/\s*$/,"");v=v.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");var u=o("EqSource","MathJax Equation Source");if(a.isMobile){r.document.open();r.document.write("<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0' /><title>"+u+"</title></head><body style='font-size:85%'>");r.document.write("<pre>"+v+"</pre>");r.document.write("<hr><input type='button' value='"+o("Close","Close")+"' onclick='window.close()' />");r.document.write("</body></html>");r.document.close()}else{r.document.open();r.document.write("<html><head><title>"+u+"</title></head><body style='font-size:85%'>");r.document.write("<table><tr><td><pre>"+v+"</pre></td></tr></table>");r.document.write("</body></html>");r.document.close();var s=r.document.body.firstChild;setTimeout(function(){var A=(r.outerHeight-r.innerHeight)||30,z=(r.outerWidth-r.innerWidth)||30,w,B;z=Math.max(100,Math.min(Math.floor(0.5*screen.width),s.offsetWidth+z+25));A=Math.max(40,Math.min(Math.floor(0.5*screen.height),s.offsetHeight+A+25));r.resizeTo(z,A);if(t&&t.screenX!=null){w=Math.max(0,Math.min(t.screenX-Math.floor(z/2),screen.width-z-20));B=Math.max(0,Math.min(t.screenY-Math.floor(A/2),screen.height-A-20));r.moveTo(w,B)}},50)}};a.Scale=function(){var s=b["HTML-CSS"],r=b.NativeMML,v=b.SVG;var u=(s||r||v||{config:{scale:100}}).config.scale;var t=prompt(o("ScaleMath","Scale all mathematics (compared to surrounding text) by"),u+"%");if(t){if(t.match(/^\s*\d+(\.\d*)?\s*%?\s*$/)){t=parseFloat(t);if(t){if(t!==u){if(s){s.config.scale=t}if(r){r.config.scale=t}if(v){v.config.scale=t}a.cookie.scale=t;a.saveCookie();c.Reprocess()}}else{alert(o("NonZeroScale","The scale should not be zero"))}}else{alert(o("PercentScale","The scale should be a percentage (e.g., 120%%)"))}}};a.Zoom=function(){if(!MathJax.Extension.MathZoom){k.Require("[MathJax]/extensions/MathZoom.js")}};a.Renderer=function(){var s=c.outputJax["jax/mml"];if(s[0]!==p.settings.renderer){var v=c.Browser,u,r=a.Renderer.Messages,t;switch(p.settings.renderer){case"NativeMML":if(!p.settings.warnedMML){if(v.isChrome&&v.version.substr(0,3)!=="24."){u=r.MML.WebKit}else{if(v.isSafari&&!v.versionAtLeast("5.0")){u=r.MML.WebKit}else{if(v.isMSIE){if(!v.hasMathPlayer){u=r.MML.MSIE}}else{u=r.MML[v]}}}t="warnedMML"}break;case"SVG":if(!p.settings.warnedSVG){if(v.isMSIE&&!e){u=r.SVG.MSIE}}break}if(u){u=o(u[0],u[1]);u+="\n\n";u+=o("SwitchAnyway","Switch the renderer anyway?\n\n(Press OK to switch, CANCEL to continue with the current renderer)");a.cookie.renderer=s[0].id;a.saveCookie();if(!confirm(u)){a.cookie.renderer=p.settings.renderer=g.Cookie.Get("menu").renderer;a.saveCookie();return}if(t){a.cookie.warned=p.settings.warned=true}a.cookie.renderer=p.settings.renderer;a.saveCookie()}c.Queue(["setRenderer",c,p.settings.renderer,"jax/mml"],["Rerender",c])}};a.Renderer.Messages={MML:{WebKit:["WebkitNativeMMLWarning","Your browser doesn't seem to support MathML natively, so switching to MathML output may cause the mathematics on the page to become unreadable."],MSIE:["MSIENativeMMLWarning","Internet Explorer requires the MathPlayer plugin in order to process MathML output."],Opera:["OperaNativeMMLWarning","Opera's support for MathML is limited, so switching to MathML output may cause some expressions to render poorly."],Safari:["SafariNativeMMLWarning","Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly."],Firefox:["FirefoxNativeMMLWarning","Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly."]},SVG:{MSIE:["MSIESVGWarning","SVG is not implemented in Internet Explorer prior to IE9 or when it is emulating IE8 or below. Switching to SVG output will cause the mathematics to not display properly."]}};a.Font=function(){var r=b["HTML-CSS"];if(!r){return}document.location.reload()};a.Locale=function(){MathJax.Localization.setLocale(p.settings.locale);MathJax.Hub.Queue(["Reprocess",MathJax.Hub])};a.LoadLocale=function(){var r=prompt(o("LoadURL","Load translation data from this URL:"));if(r){if(!r.match(/\.js$/)){alert(o("BadURL","The URL should be for a javascript file that defines MathJax translation data.  Javascript file names should end with '.js'"))}k.Require(r,function(s){if(s!=k.STATUS.OK){alert(o("BadData","Failed to load translation data from %1",r))}})}};a.MPEvents=function(t){var s=p.settings.discoverable,r=a.MPEvents.Messages;if(!e){if(p.settings.mpMouse&&!confirm(o.apply(o,r.IE8warning))){delete a.cookie.mpContext;delete p.settings.mpContext;delete a.cookie.mpMouse;delete p.settings.mpMouse;a.saveCookie();return}p.settings.mpContext=p.settings.mpMouse;a.cookie.mpContext=a.cookie.mpMouse=p.settings.mpMouse;a.saveCookie();MathJax.Hub.Queue(["Rerender",MathJax.Hub])}else{if(!s&&t.name[1]==="Menu Events"&&p.settings.mpContext){alert(o.apply(o,r.IE9warning))}}};a.MPEvents.Messages={IE8warning:["IE8warning","This will disable the MathJax menu and zoom features, but you can Alt-Click on an expression to obtain the MathJax menu instead.\n\nReally change the MathPlayer settings?"],IE9warning:["IE9warning","The MathJax contextual menu will be disabled, but you can Alt-Click on an expression to obtain the MathJax menu instead."]};c.Browser.Select({MSIE:function(r){var s=(document.compatMode==="BackCompat");var t=r.versionAtLeast("8.0")&&document.documentMode>7;a.Augment({margin:20,msieBackgroundBug:(document.documentMode<9),msieFixedPositionBug:(s||!t),msieAboutBug:s});if(e){delete p.styles["#MathJax_About"].filter;delete p.styles[".MathJax_Menu"].filter}},Firefox:function(r){a.skipMouseover=r.isMobile&&r.versionAtLeast("6.0");a.skipMousedown=r.isMobile}});a.isMobile=c.Browser.isMobile;a.noContextMenu=c.Browser.noContextMenu;a.CreateLocaleMenu=function(){if(!a.menu){return}var w=a.menu.Find("Language").menu,t=w.items;var s=[],y=MathJax.Localization.strings;for(var x in y){if(y.hasOwnProperty(x)){s.push(x)}}s=s.sort();w.items=[];for(var u=0,r=s.length;u<r;u++){var v=y[s[u]].menuTitle;if(v){v+=" ("+s[u]+")"}else{v=s[u]}w.items.push(m.RADIO([s[u],v],"locale",{action:a.Locale}))}w.items.push(t[t.length-2],t[t.length-1])};a.CreateAnnotationMenu=function(){if(!a.menu){return}var t=a.menu.Find("Show Math As","Annotation").menu;var s=p.semanticsAnnotations;for(var r in s){if(s.hasOwnProperty(r)){t.items.push(m.COMMAND([r,r],a.ShowSource,{hidden:true,nativeTouch:true,format:r}))}}};c.Register.StartupHook("End Config",function(){p.settings=c.config.menuSettings;if(typeof(p.settings.showRenderer)!=="undefined"){p.showRenderer=p.settings.showRenderer}if(typeof(p.settings.showFontMenu)!=="undefined"){p.showFontMenu=p.settings.showFontMenu}if(typeof(p.settings.showContext)!=="undefined"){p.showContext=p.settings.showContext}a.getCookie();a.menu=a(m.SUBMENU(["Show","Show Math As"],m.COMMAND(["MathMLcode","MathML Code"],a.ShowSource,{nativeTouch:true,format:"MathML"}),m.COMMAND(["Original","Original Form"],a.ShowSource,{nativeTouch:true}),m.SUBMENU(["Annotation","Annotation"],{disabled:true}),m.RULE(),m.CHECKBOX(["texHints","Show TeX hints in MathML"],"texHints")),m.RULE(),m.SUBMENU(["Settings","Math Settings"],m.SUBMENU(["ZoomTrigger","Zoom Trigger"],m.RADIO(["Hover","Hover"],"zoom",{action:a.Zoom}),m.RADIO(["Click","Click"],"zoom",{action:a.Zoom}),m.RADIO(["DoubleClick","Double-Click"],"zoom",{action:a.Zoom}),m.RADIO(["NoZoom","No Zoom"],"zoom",{value:"None"}),m.RULE(),m.LABEL(["TriggerRequires","Trigger Requires:"]),m.CHECKBOX((c.Browser.isMac?["Option","Option"]:["Alt","Alt"]),"ALT"),m.CHECKBOX(["Command","Command"],"CMD",{hidden:!c.Browser.isMac}),m.CHECKBOX(["Control","Control"],"CTRL",{hidden:c.Browser.isMac}),m.CHECKBOX(["Shift","Shift"],"Shift")),m.SUBMENU(["ZoomFactor","Zoom Factor"],m.RADIO("125%","zscale"),m.RADIO("133%","zscale"),m.RADIO("150%","zscale"),m.RADIO("175%","zscale"),m.RADIO("200%","zscale"),m.RADIO("250%","zscale"),m.RADIO("300%","zscale"),m.RADIO("400%","zscale")),m.RULE(),m.SUBMENU(["Renderer","Math Renderer"],{hidden:!p.showRenderer},m.RADIO("HTML-CSS","renderer",{action:a.Renderer}),m.RADIO("MathML","renderer",{action:a.Renderer,value:"NativeMML"}),m.RADIO("SVG","renderer",{action:a.Renderer})),m.SUBMENU("MathPlayer",{hidden:!c.Browser.isMSIE||!p.showMathPlayer,disabled:!c.Browser.hasMathPlayer},m.LABEL(["MPHandles","Let MathPlayer Handle:"]),m.CHECKBOX(["MenuEvents","Menu Events"],"mpContext",{action:a.MPEvents,hidden:!e}),m.CHECKBOX(["MouseEvents","Mouse Events"],"mpMouse",{action:a.MPEvents,hidden:!e}),m.CHECKBOX(["MenuAndMouse","Mouse and Menu Events"],"mpMouse",{action:a.MPEvents,hidden:e})),m.SUBMENU(["FontPrefs","Font Preference"],{hidden:!p.showFontMenu},m.LABEL(["ForHTMLCSS","For HTML-CSS:"]),m.RADIO(["Auto","Auto"],"font",{action:a.Font}),m.RULE(),m.RADIO(["TeXLocal","TeX (local)"],"font",{action:a.Font}),m.RADIO(["TeXWeb","TeX (web)"],"font",{action:a.Font}),m.RADIO(["TeXImage","TeX (image)"],"font",{action:a.Font}),m.RULE(),m.RADIO(["STIXLocal","STIX (local)"],"font",{action:a.Font}),m.RADIO(["STIXWeb","STIX (web)"],"font",{action:a.Font})),m.SUBMENU(["ContextMenu","Contextual Menu"],{hidden:!p.showContext},m.RADIO("MathJax","context"),m.RADIO(["Browser","Browser"],"context")),m.COMMAND(["Scale","Scale All Math ..."],a.Scale),m.RULE().With({hidden:!p.showDiscoverable,name:["","discover_rule"]}),m.CHECKBOX(["Discoverable","Highlight on Hover"],"discoverable",{hidden:!p.showDiscoverable})),m.SUBMENU(["Locale","Language"],{hidden:!p.showLocale},m.RADIO("en","locale",{action:a.Locale}),m.RULE().With({hidden:!p.showLocaleURL,name:["","localURL_rule"]}),m.COMMAND(["LoadLocale","Load from URL ..."],a.LoadLocale,{hidden:!p.showLocaleURL})),m.RULE(),m.COMMAND(["About","About MathJax"],a.About),m.COMMAND(["Help","MathJax Help"],a.Help));if(a.isMobile){(function(){var s=p.settings;var r=a.menu.Find("Math Settings","Zoom Trigger").menu;r.items[0].disabled=r.items[1].disabled=true;if(s.zoom==="Hover"||s.zoom=="Click"){s.zoom="None"}r.items=r.items.slice(0,4);if(navigator.appVersion.match(/[ (]Android[) ]/)){a.ITEM.SUBMENU.Augment({marker:"\u00BB"})}})()}a.CreateLocaleMenu();a.CreateAnnotationMenu()});a.showRenderer=function(r){a.cookie.showRenderer=p.showRenderer=r;a.saveCookie();a.menu.Find("Math Settings","Math Renderer").hidden=!r};a.showMathPlayer=function(r){a.cookie.showMathPlayer=p.showMathPlayer=r;a.saveCookie();a.menu.Find("Math Settings","MathPlayer").hidden=!r};a.showFontMenu=function(r){a.cookie.showFontMenu=p.showFontMenu=r;a.saveCookie();a.menu.Find("Math Settings","Font Preference").hidden=!r};a.showContext=function(r){a.cookie.showContext=p.showContext=r;a.saveCookie();a.menu.Find("Math Settings","Contextual Menu").hidden=!r};a.showDiscoverable=function(r){a.cookie.showDiscoverable=p.showDiscoverable=r;a.saveCookie();a.menu.Find("Math Settings","Highlight on Hover").hidden=!r;a.menu.Find("Math Settings","discover_rule").hidden=!r};a.showLocale=function(r){a.cookie.showLocale=p.showLocale=r;a.saveCookie();a.menu.Find("Language").hidden=!r};MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){if(!MathJax.OutputJax["HTML-CSS"].config.imageFont){a.menu.Find("Math Settings","Font Preference","TeX (image)").disabled=true}});f.Queue(c.Register.StartupHook("End Config",{}),["getImages",a],["Styles",k,p.styles],["Post",c.Startup.signal,"MathMenu Ready"],["loadComplete",k,"[MathJax]/extensions/MathMenu.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.CallBack,MathJax.OutputJax);
MathJax.ElementJax.mml=MathJax.ElementJax({mimeType:"jax/mml"},{id:"mml",version:"2.3",directory:MathJax.ElementJax.directory+"/mml",extensionDir:MathJax.ElementJax.extensionDir+"/mml",optableDir:MathJax.ElementJax.directory+"/mml/optable"});MathJax.ElementJax.mml.Augment({Init:function(){if(arguments.length===1&&arguments[0].type==="math"){this.root=arguments[0]}else{this.root=MathJax.ElementJax.mml.math.apply(this,arguments)}if(this.root.attr&&this.root.attr.mode){if(!this.root.display&&this.root.attr.mode==="display"){this.root.display="block";this.root.attrNames.push("display")}delete this.root.attr.mode;for(var b=0,a=this.root.attrNames.length;b<a;b++){if(this.root.attrNames[b]==="mode"){this.root.attrNames.splice(b,1);break}}}}},{INHERIT:"_inherit_",AUTO:"_auto_",SIZE:{INFINITY:"infinity",SMALL:"small",NORMAL:"normal",BIG:"big"},COLOR:{TRANSPARENT:"transparent"},VARIANT:{NORMAL:"normal",BOLD:"bold",ITALIC:"italic",BOLDITALIC:"bold-italic",DOUBLESTRUCK:"double-struck",FRAKTUR:"fraktur",BOLDFRAKTUR:"bold-fraktur",SCRIPT:"script",BOLDSCRIPT:"bold-script",SANSSERIF:"sans-serif",BOLDSANSSERIF:"bold-sans-serif",SANSSERIFITALIC:"sans-serif-italic",SANSSERIFBOLDITALIC:"sans-serif-bold-italic",MONOSPACE:"monospace",INITIAL:"inital",TAILED:"tailed",LOOPED:"looped",STRETCHED:"stretched",CALIGRAPHIC:"-tex-caligraphic",OLDSTYLE:"-tex-oldstyle"},FORM:{PREFIX:"prefix",INFIX:"infix",POSTFIX:"postfix"},LINEBREAK:{AUTO:"auto",NEWLINE:"newline",NOBREAK:"nobreak",GOODBREAK:"goodbreak",BADBREAK:"badbreak"},LINEBREAKSTYLE:{BEFORE:"before",AFTER:"after",DUPLICATE:"duplicate",INFIXLINBREAKSTYLE:"infixlinebreakstyle"},INDENTALIGN:{LEFT:"left",CENTER:"center",RIGHT:"right",AUTO:"auto",ID:"id",INDENTALIGN:"indentalign"},INDENTSHIFT:{INDENTSHIFT:"indentshift"},LINETHICKNESS:{THIN:"thin",MEDIUM:"medium",THICK:"thick"},NOTATION:{LONGDIV:"longdiv",ACTUARIAL:"actuarial",RADICAL:"radical",BOX:"box",ROUNDEDBOX:"roundedbox",CIRCLE:"circle",LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom",UPDIAGONALSTRIKE:"updiagonalstrike",DOWNDIAGONALSTRIKE:"downdiagonalstrike",UPDIAGONALARROW:"updiagonalarrow",VERTICALSTRIKE:"verticalstrike",HORIZONTALSTRIKE:"horizontalstrike",MADRUWB:"madruwb"},ALIGN:{TOP:"top",BOTTOM:"bottom",CENTER:"center",BASELINE:"baseline",AXIS:"axis",LEFT:"left",RIGHT:"right"},LINES:{NONE:"none",SOLID:"solid",DASHED:"dashed"},SIDE:{LEFT:"left",RIGHT:"right",LEFTOVERLAP:"leftoverlap",RIGHTOVERLAP:"rightoverlap"},WIDTH:{AUTO:"auto",FIT:"fit"},ACTIONTYPE:{TOGGLE:"toggle",STATUSLINE:"statusline",TOOLTIP:"tooltip",INPUT:"input"},LENGTH:{VERYVERYTHINMATHSPACE:"veryverythinmathspace",VERYTHINMATHSPACE:"verythinmathspace",THINMATHSPACE:"thinmathspace",MEDIUMMATHSPACE:"mediummathspace",THICKMATHSPACE:"thickmathspace",VERYTHICKMATHSPACE:"verythickmathspace",VERYVERYTHICKMATHSPACE:"veryverythickmathspace",NEGATIVEVERYVERYTHINMATHSPACE:"negativeveryverythinmathspace",NEGATIVEVERYTHINMATHSPACE:"negativeverythinmathspace",NEGATIVETHINMATHSPACE:"negativethinmathspace",NEGATIVEMEDIUMMATHSPACE:"negativemediummathspace",NEGATIVETHICKMATHSPACE:"negativethickmathspace",NEGATIVEVERYTHICKMATHSPACE:"negativeverythickmathspace",NEGATIVEVERYVERYTHICKMATHSPACE:"negativeveryverythickmathspace"},OVERFLOW:{LINBREAK:"linebreak",SCROLL:"scroll",ELIDE:"elide",TRUNCATE:"truncate",SCALE:"scale"},UNIT:{EM:"em",EX:"ex",PX:"px",IN:"in",CM:"cm",MM:"mm",PT:"pt",PC:"pc"},TEXCLASS:{ORD:0,OP:1,BIN:2,REL:3,OPEN:4,CLOSE:5,PUNCT:6,INNER:7,VCENTER:8,NONE:-1},TEXCLASSNAMES:["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"],copyAttributes:{fontfamily:true,fontsize:true,fontweight:true,fontstyle:true,color:true,background:true,id:true,"class":true,href:true,style:true},skipAttributes:{texClass:true,useHeight:true,texprimestyle:true},copyAttributeNames:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"],Error:function(d,e){var c=this.merror(d),b=MathJax.Localization.fontDirection(),a=MathJax.Localization.fontFamily();if(e){c=c.With(e)}if(b||a){c=this.mstyle(c);if(b){c.dir=b}if(a){c.style.fontFamily="font-family: "+a}}return c}});(function(a){a.mbase=MathJax.Object.Subclass({type:"base",isToken:false,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT},noInherit:{},noInheritAttribute:{texClass:true},linebreakContainer:false,Init:function(){this.data=[];if(this.inferRow&&!(arguments.length===1&&arguments[0].inferred)){this.Append(a.mrow().With({inferred:true,notParent:true}))}this.Append.apply(this,arguments)},With:function(d){for(var e in d){if(d.hasOwnProperty(e)){this[e]=d[e]}}return this},Append:function(){if(this.inferRow&&this.data.length){this.data[0].Append.apply(this.data[0],arguments)}else{for(var e=0,d=arguments.length;e<d;e++){this.SetData(this.data.length,arguments[e])}}},SetData:function(d,e){if(e!=null){if(!(e instanceof a.mbase)){e=(this.isToken?a.chars(e):a.mtext(e))}e.parent=this;e.setInherit(this.inheritFromMe?this:this.inherit)}this.data[d]=e},Parent:function(){var d=this.parent;while(d&&d.notParent){d=d.parent}return d},Get:function(e,j){if(this[e]!=null){return this[e]}if(this.attr&&this.attr[e]!=null){return this.attr[e]}var f=this.Parent();if(f&&f["adjustChild_"+e]!=null){return(f["adjustChild_"+e])(this.childPosition(),j)}var i=this.inherit;var d=i;while(i){var h=i[e];if(h==null&&i.attr){h=i.attr[e]}if(h!=null&&i.noInheritAttribute&&!i.noInheritAttribute[e]){var g=i.noInherit[this.type];if(!(g&&g[e])){return h}}d=i;i=i.inherit}if(!j){if(this.defaults[e]===a.AUTO){return this.autoDefault(e)}if(this.defaults[e]!==a.INHERIT&&this.defaults[e]!=null){return this.defaults[e]}if(d){return d.defaults[e]}}return null},hasValue:function(d){return(this.Get(d,true)!=null)},getValues:function(){var e={};for(var f=0,d=arguments.length;f<d;f++){e[arguments[f]]=this.Get(arguments[f])}return e},adjustChild_scriptlevel:function(e,d){return this.Get("scriptlevel",d)},adjustChild_displaystyle:function(e,d){return this.Get("displaystyle",d)},adjustChild_texprimestyle:function(e,d){return this.Get("texprimestyle",d)},childPosition:function(){var g=this,f=g.parent;while(f.notParent){g=f;f=g.parent}for(var e=0,d=f.data.length;e<d;e++){if(f.data[e]===g){return e}}return null},setInherit:function(f){if(f!==this.inherit&&this.inherit==null){this.inherit=f;for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&this.data[e].setInherit){this.data[e].setInherit(f)}}}},setTeXclass:function(d){this.getPrevClass(d);return(typeof(this.texClass)!=="undefined"?this:d)},getPrevClass:function(d){if(d){this.prevClass=d.Get("texClass");this.prevLevel=d.Get("scriptlevel")}},updateTeXclass:function(d){if(d){this.prevClass=d.prevClass;delete d.prevClass;this.prevLevel=d.prevLevel;delete d.prevLevel;this.texClass=d.Get("texClass")}},texSpacing:function(){var e=(this.prevClass!=null?this.prevClass:a.TEXCLASS.NONE);var d=(this.Get("texClass")||a.TEXCLASS.ORD);if(e===a.TEXCLASS.NONE||d===a.TEXCLASS.NONE){return""}if(e===a.TEXCLASS.VCENTER){e=a.TEXCLASS.ORD}if(d===a.TEXCLASS.VCENTER){d=a.TEXCLASS.ORD}var f=this.TEXSPACE[e][d];if(this.prevLevel>0&&this.Get("scriptlevel")>0&&f>=0){return""}return this.TEXSPACELENGTH[Math.abs(f)]},TEXSPACELENGTH:["",a.LENGTH.THINMATHSPACE,a.LENGTH.MEDIUMMATHSPACE,a.LENGTH.THICKMATHSPACE],TEXSPACE:[[0,-1,2,3,0,0,0,1],[-1,-1,0,3,0,0,0,1],[2,2,0,0,2,0,0,2],[3,3,0,0,3,0,0,3],[0,0,0,0,0,0,0,0],[0,-1,2,3,0,0,0,1],[1,1,0,1,1,1,1,1],[1,-1,2,3,1,0,1,1]],autoDefault:function(d){return""},isSpacelike:function(){return false},isEmbellished:function(){return false},Core:function(){return this},CoreMO:function(){return this},hasNewline:function(){if(this.isEmbellished()){return this.CoreMO().hasNewline()}if(this.isToken||this.linebreakContainer){return false}for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&this.data[e].hasNewline()){return true}}return false},array:function(){if(this.inferred){return this.data}else{return[this]}},toString:function(){return this.type+"("+this.data.join(",")+")"},getAnnotation:function(){return null}},{childrenSpacelike:function(){for(var e=0,d=this.data.length;e<d;e++){if(!this.data[e].isSpacelike()){return false}}return true},childEmbellished:function(){return(this.data[0]&&this.data[0].isEmbellished())},childCore:function(){return this.data[0]},childCoreMO:function(){return(this.data[0]?this.data[0].CoreMO():null)},setChildTeXclass:function(d){if(this.data[0]){d=this.data[0].setTeXclass(d);this.updateTeXclass(this.data[0])}return d},setBaseTeXclasses:function(f){this.getPrevClass(f);this.texClass=null;if(this.data[0]){if(this.isEmbellished()||this.data[0].isa(a.mi)){f=this.data[0].setTeXclass(f);this.updateTeXclass(this.Core())}else{this.data[0].setTeXclass();f=this}}else{f=this}for(var e=1,d=this.data.length;e<d;e++){if(this.data[e]){this.data[e].setTeXclass()}}return f},setSeparateTeXclasses:function(f){this.getPrevClass(f);for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]){this.data[e].setTeXclass()}}if(this.isEmbellished()){this.updateTeXclass(this.Core())}return this}});a.mi=a.mbase.Subclass({type:"mi",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.AUTO,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT},autoDefault:function(e){if(e==="mathvariant"){var d=(this.data[0]||"").toString();return(d.length===1||(d.length===2&&d.charCodeAt(0)>=55296&&d.charCodeAt(0)<56320)?a.VARIANT.ITALIC:a.VARIANT.NORMAL)}return""},setTeXclass:function(e){this.getPrevClass(e);var d=this.data.join("");if(d.length>1&&d.match(/^[a-z][a-z0-9]*$/i)&&this.texClass===a.TEXCLASS.ORD){this.texClass=a.TEXCLASS.OP;this.autoOP=true}return this}});a.mn=a.mbase.Subclass({type:"mn",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT}});a.mo=a.mbase.Subclass({type:"mo",isToken:true,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,form:a.AUTO,fence:a.AUTO,separator:a.AUTO,lspace:a.AUTO,rspace:a.AUTO,stretchy:a.AUTO,symmetric:a.AUTO,maxsize:a.AUTO,minsize:a.AUTO,largeop:a.AUTO,movablelimits:a.AUTO,accent:a.AUTO,linebreak:a.LINEBREAK.AUTO,lineleading:a.INHERIT,linebreakstyle:a.AUTO,linebreakmultchar:a.INHERIT,indentalign:a.INHERIT,indentshift:a.INHERIT,indenttarget:a.INHERIT,indentalignfirst:a.INHERIT,indentshiftfirst:a.INHERIT,indentalignlast:a.INHERIT,indentshiftlast:a.INHERIT,texClass:a.AUTO},defaultDef:{form:a.FORM.INFIX,fence:false,separator:false,lspace:a.LENGTH.THICKMATHSPACE,rspace:a.LENGTH.THICKMATHSPACE,stretchy:false,symmetric:true,maxsize:a.SIZE.INFINITY,minsize:"0em",largeop:false,movablelimits:false,accent:false,linebreak:a.LINEBREAK.AUTO,lineleading:"1ex",linebreakstyle:"before",indentalign:a.INDENTALIGN.AUTO,indentshift:"0",indenttarget:"",indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,texClass:a.TEXCLASS.REL},SPACE_ATTR:{lspace:1,rspace:2,form:4},useMMLspacing:7,autoDefault:function(f,l){var k=this.def;if(!k){if(f==="form"){this.useMMLspacing&=~this.SPACE_ATTR.form;return this.getForm()}var j=this.data.join("");var e=[this.Get("form"),a.FORM.INFIX,a.FORM.POSTFIX,a.FORM.PREFIX];for(var g=0,d=e.length;g<d;g++){var h=this.OPTABLE[e[g]][j];if(h){k=this.makeDef(h);break}}if(!k){k=this.CheckRange(j)}if(!k&&l){k={}}else{if(!k){k=MathJax.Hub.Insert({},this.defaultDef)}k.form=e[0];this.def=k}}this.useMMLspacing&=~(this.SPACE_ATTR[f]||0);if(k[f]!=null){return k[f]}else{if(!l){return this.defaultDef[f]}}return""},CheckRange:function(h){var j=h.charCodeAt(0);if(j>=55296&&j<56320){j=(((j-55296)<<10)+(h.charCodeAt(1)-56320))+65536}for(var f=0,d=this.RANGES.length;f<d&&this.RANGES[f][0]<=j;f++){if(j<=this.RANGES[f][1]){if(this.RANGES[f][3]){var e=a.optableDir+"/"+this.RANGES[f][3]+".js";this.RANGES[f][3]=null;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(e))}var g=a.TEXCLASSNAMES[this.RANGES[f][2]];g=this.OPTABLE.infix[h]=a.mo.OPTYPES[g==="BIN"?"BIN3":g];return this.makeDef(g)}}return null},makeDef:function(e){if(e[2]==null){e[2]=this.defaultDef.texClass}if(!e[3]){e[3]={}}var d=MathJax.Hub.Insert({},e[3]);d.lspace=this.SPACE[e[0]];d.rspace=this.SPACE[e[1]];d.texClass=e[2];if(d.texClass===a.TEXCLASS.REL&&(this.movablelimits||this.data.join("").match(/^[a-z]+$/i))){d.texClass=a.TEXCLASS.OP}return d},getForm:function(){var d=this,f=this.parent,e=this.Parent();while(e&&e.isEmbellished()){d=f;f=e.parent;e=e.Parent()}if(f&&f.type==="mrow"&&f.NonSpaceLength()!==1){if(f.FirstNonSpace()===d){return a.FORM.PREFIX}if(f.LastNonSpace()===d){return a.FORM.POSTFIX}}return a.FORM.INFIX},isEmbellished:function(){return true},hasNewline:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE)},setTeXclass:function(d){this.getValues("lspace","rspace");if(this.useMMLspacing){this.texClass=a.TEXCLASS.NONE;return this}this.texClass=this.Get("texClass");if(this.data.join("")==="\u2061"){if(d){d.texClass=a.TEXCLASS.OP}this.texClass=this.prevClass=a.TEXCLASS.NONE;return d}return this.adjustTeXclass(d)},adjustTeXclass:function(d){if(this.texClass===a.TEXCLASS.NONE){return d}if(d){if(d.autoOP&&(this.texClass===a.TEXCLASS.BIN||this.texClass===a.TEXCLASS.REL)){d.texClass=a.TEXCLASS.ORD}this.prevClass=d.texClass||a.TEXCLASS.ORD;this.prevLevel=d.Get("scriptlevel")}else{this.prevClass=a.TEXCLASS.NONE}if(this.texClass===a.TEXCLASS.BIN&&(this.prevClass===a.TEXCLASS.NONE||this.prevClass===a.TEXCLASS.BIN||this.prevClass===a.TEXCLASS.OP||this.prevClass===a.TEXCLASS.REL||this.prevClass===a.TEXCLASS.OPEN||this.prevClass===a.TEXCLASS.PUNCT)){this.texClass=a.TEXCLASS.ORD}else{if(this.prevClass===a.TEXCLASS.BIN&&(this.texClass===a.TEXCLASS.REL||this.texClass===a.TEXCLASS.CLOSE||this.texClass===a.TEXCLASS.PUNCT)){d.texClass=this.prevClass=a.TEXCLASS.ORD}}return this}});a.mtext=a.mbase.Subclass({type:"mtext",isToken:true,isSpacelike:function(){return true},texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT}});a.mspace=a.mbase.Subclass({type:"mspace",isToken:true,isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"0em",height:"0ex",depth:"0ex",linebreak:a.LINEBREAK.AUTO},hasDimAttr:function(){return(this.hasValue("width")||this.hasValue("height")||this.hasValue("depth"))},hasNewline:function(){return(!this.hasDimAttr()&&this.Get("linebreak")===a.LINEBREAK.NEWLINE)}});a.ms=a.mbase.Subclass({type:"ms",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,lquote:'"',rquote:'"'}});a.mglyph=a.mbase.Subclass({type:"mglyph",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,alt:"",src:"",width:a.AUTO,height:a.AUTO,valign:"0em"}});a.mrow=a.mbase.Subclass({type:"mrow",isSpacelike:a.mbase.childrenSpacelike,inferred:false,notParent:false,isEmbellished:function(){var e=false;for(var f=0,d=this.data.length;f<d;f++){if(this.data[f]==null){continue}if(this.data[f].isEmbellished()){if(e){return false}e=true;this.core=f}else{if(!this.data[f].isSpacelike()){return false}}}return e},NonSpaceLength:function(){var f=0;for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&!this.data[e].isSpacelike()){f++}}return f},FirstNonSpace:function(){for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&!this.data[e].isSpacelike()){return this.data[e]}}return null},LastNonSpace:function(){for(var d=this.data.length-1;d>=0;d--){if(this.data[0]&&!this.data[d].isSpacelike()){return this.data[d]}}return null},Core:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core]},CoreMO:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core].CoreMO()},toString:function(){if(this.inferred){return"["+this.data.join(",")+"]"}return this.SUPER(arguments).toString.call(this)},setTeXclass:function(f){for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]){f=this.data[e].setTeXclass(f)}}if(this.data[0]){this.updateTeXclass(this.data[0])}return f},getAnnotation:function(d){if(this.data.length!=1){return null}return this.data[0].getAnnotation(d)}});a.mfrac=a.mbase.Subclass({type:"mfrac",num:0,den:1,linebreakContainer:true,texClass:a.TEXCLASS.INNER,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,linethickness:a.LINETHICKNESS.MEDIUM,numalign:a.ALIGN.CENTER,denomalign:a.ALIGN.CENTER,bevelled:false},adjustChild_displaystyle:function(d){return false},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(!this.Get("displaystyle")||d>0){d++}return d},adjustChild_texprimestyle:function(d){if(d==this.den){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.msqrt=a.mbase.Subclass({type:"msqrt",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD,setTeXclass:a.mbase.setSeparateTeXclasses,adjustChild_texprimestyle:function(d){return true}});a.mroot=a.mbase.Subclass({type:"mroot",linebreakContainer:true,texClass:a.TEXCLASS.ORD,adjustChild_displaystyle:function(d){if(d===1){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(e===1){d+=2}return d},adjustChild_texprimestyle:function(d){if(d===0){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.mstyle=a.mbase.Subclass({type:"mstyle",isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,inferRow:true,defaults:{scriptlevel:a.INHERIT,displaystyle:a.INHERIT,scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8pt",mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,decimalseparator:"."},adjustChild_scriptlevel:function(f){var e=this.scriptlevel;if(e==null){e=this.Get("scriptlevel")}else{if(String(e).match(/^ *[-+]/)){delete this.scriptlevel;var d=this.Get("scriptlevel");this.scriptlevel=e;e=d+parseInt(e)}}return e},inheritFromMe:true,noInherit:{mpadded:{width:true,height:true,depth:true,lspace:true,voffset:true},mtable:{width:true,height:true,depth:true,align:true}},setTeXclass:a.mbase.setChildTeXclass});a.merror=a.mbase.Subclass({type:"merror",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD});a.mpadded=a.mbase.Subclass({type:"mpadded",inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"",height:"",depth:"",lspace:0,voffset:0},setTeXclass:a.mbase.setChildTeXclass});a.mphantom=a.mbase.Subclass({type:"mphantom",texClass:a.TEXCLASS.ORD,inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,setTeXclass:a.mbase.setChildTeXclass});a.mfenced=a.mbase.Subclass({type:"mfenced",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,open:"(",close:")",separators:","},texClass:a.TEXCLASS.OPEN,setTeXclass:function(g){this.getPrevClass(g);var e=this.getValues("open","close","separators");e.open=e.open.replace(/[ \t\n\r]/g,"");e.close=e.close.replace(/[ \t\n\r]/g,"");e.separators=e.separators.replace(/[ \t\n\r]/g,"");if(e.open!==""){this.SetData("open",a.mo(e.open).With({stretchy:true,texClass:a.TEXCLASS.OPEN}));g=this.data.open.setTeXclass(g)}if(e.separators!==""){while(e.separators.length<this.data.length){e.separators+=e.separators.charAt(e.separators.length-1)}}if(this.data[0]){g=this.data[0].setTeXclass(g)}for(var f=1,d=this.data.length;f<d;f++){if(this.data[f]){if(e.separators!==""){this.SetData("sep"+f,a.mo(e.separators.charAt(f-1)));g=this.data["sep"+f].setTeXclass(g)}g=this.data[f].setTeXclass(g)}}if(e.close!==""){this.SetData("close",a.mo(e.close).With({stretchy:true,texClass:a.TEXCLASS.CLOSE}));g=this.data.close.setTeXclass(g)}this.updateTeXclass(this.data.open);return g}});a.menclose=a.mbase.Subclass({type:"menclose",inferRow:true,linebreakContainer:true,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,notation:a.NOTATION.LONGDIV,texClass:a.TEXCLASS.ORD},setTeXclass:a.mbase.setSeparateTeXclasses});a.msubsup=a.mbase.Subclass({type:"msubsup",base:0,sub:1,sup:2,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,subscriptshift:"",superscriptshift:"",texClass:a.AUTO},autoDefault:function(d){if(d==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(d):a.TEXCLASS.ORD)}return 0},adjustChild_displaystyle:function(d){if(d>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(e>0){d++}return d},adjustChild_texprimestyle:function(d){if(d===this.sub){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.msub=a.msubsup.Subclass({type:"msub"});a.msup=a.msubsup.Subclass({type:"msup",sub:2,sup:1});a.mmultiscripts=a.msubsup.Subclass({type:"mmultiscripts",adjustChild_texprimestyle:function(d){if(d%2===1){return true}return this.Get("texprimestyle")}});a.mprescripts=a.mbase.Subclass({type:"mprescripts"});a.none=a.mbase.Subclass({type:"none"});a.munderover=a.mbase.Subclass({type:"munderover",base:0,under:1,over:2,sub:1,sup:2,ACCENTS:["","accentunder","accent"],linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,accent:a.AUTO,accentunder:a.AUTO,align:a.ALIGN.CENTER,texClass:a.AUTO,subscriptshift:"",superscriptshift:""},autoDefault:function(d){if(d==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(d):a.TEXCLASS.ORD)}if(d==="accent"&&this.data[this.over]){return this.data[this.over].CoreMO().Get("accent")}if(d==="accentunder"&&this.data[this.under]){return this.data[this.under].CoreMO().Get("accent")}return false},adjustChild_displaystyle:function(d){if(d>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");var d=(this.data[this.base]&&!this.Get("displaystyle")&&this.data[this.base].CoreMO().Get("movablelimits"));if(f==this.under&&(d||!this.Get("accentunder"))){e++}if(f==this.over&&(d||!this.Get("accent"))){e++}return e},adjustChild_texprimestyle:function(d){if(d===this.base&&this.data[this.over]){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.munder=a.munderover.Subclass({type:"munder"});a.mover=a.munderover.Subclass({type:"mover",over:1,under:2,sup:1,sub:2,ACCENTS:["","accent","accentunder"]});a.mtable=a.mbase.Subclass({type:"mtable",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,align:a.ALIGN.AXIS,rowalign:a.ALIGN.BASELINE,columnalign:a.ALIGN.CENTER,groupalign:"{left}",alignmentscope:true,columnwidth:a.WIDTH.AUTO,width:a.WIDTH.AUTO,rowspacing:"1ex",columnspacing:".8em",rowlines:a.LINES.NONE,columnlines:a.LINES.NONE,frame:a.LINES.NONE,framespacing:"0.4em 0.5ex",equalrows:false,equalcolumns:false,displaystyle:false,side:a.SIDE.RIGHT,minlabelspacing:"0.8em",texClass:a.TEXCLASS.ORD,useHeight:1},inheritFromMe:true,noInherit:{mover:{align:true},munder:{align:true},munderover:{align:true},mtable:{align:true,rowalign:true,columnalign:true,groupalign:true,alignmentscope:true,columnwidth:true,width:true,rowspacing:true,columnspacing:true,rowlines:true,columnlines:true,frame:true,framespacing:true,equalrows:true,equalcolumns:true,side:true,minlabelspacing:true,texClass:true,useHeight:1}},linebreakContainer:true,Append:function(){for(var e=0,d=arguments.length;e<d;e++){if(!((arguments[e] instanceof a.mtr)||(arguments[e] instanceof a.mlabeledtr))){arguments[e]=a.mtd(arguments[e])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtr=a.mbase.Subclass({type:"mtr",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{rowalign:true,columnalign:true,groupalign:true},mtable:{rowalign:true,columnalign:true,groupalign:true}},linebreakContainer:true,Append:function(){for(var e=0,d=arguments.length;e<d;e++){if(!(arguments[e] instanceof a.mtd)){arguments[e]=a.mtd(arguments[e])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtd=a.mbase.Subclass({type:"mtd",inferRow:true,linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowspan:1,columnspan:1,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},setTeXclass:a.mbase.setSeparateTeXclasses});a.maligngroup=a.mbase.Subclass({type:"malign",isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{groupalign:true},mtable:{groupalign:true}}});a.malignmark=a.mbase.Subclass({type:"malignmark",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,edge:a.SIDE.LEFT},isSpacelike:function(){return true}});a.mlabeledtr=a.mtr.Subclass({type:"mlabeledtr"});a.maction=a.mbase.Subclass({type:"maction",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,actiontype:a.ACTIONTYPE.TOGGLE,selection:1},selected:function(){return this.data[this.Get("selection")-1]||a.NULL},isEmbellished:function(){return this.selected().isEmbellished()},isSpacelike:function(){return this.selected().isSpacelike()},Core:function(){return this.selected().Core()},CoreMO:function(){return this.selected().CoreMO()},setTeXclass:function(d){if(this.Get("actiontype")===a.ACTIONTYPE.TOOLTIP&&this.data[1]){this.data[1].setTeXclass()}return this.selected().setTeXclass(d)}});a.semantics=a.mbase.Subclass({type:"semantics",notParent:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{definitionURL:null,encoding:null},setTeXclass:a.mbase.setChildTeXclass,getAnnotation:function(f){var k=MathJax.Hub.config.MathMenu.semanticsAnnotations[f];if(k){for(var g=0,d=this.data.length;g<d;g++){var h=this.data[g].Get("encoding");if(h){for(var e=0,l=k.length;e<l;e++){if(k[e]===h){return this.data[g]}}}}}return null}});a.annotation=a.mbase.Subclass({type:"annotation",isToken:true,linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a["annotation-xml"]=a.mbase.Subclass({type:"annotation-xml",linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a.math=a.mstyle.Subclass({type:"math",defaults:{mathvariant:a.VARIANT.NORMAL,mathsize:a.SIZE.NORMAL,mathcolor:"",mathbackground:a.COLOR.TRANSPARENT,dir:"ltr",scriptlevel:0,displaystyle:a.AUTO,display:"inline",maxwidth:"",overflow:a.OVERFLOW.LINEBREAK,altimg:"","altimg-width":"","altimg-height":"","altimg-valign":"",alttext:"",cdgroup:"",scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8px",infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,lineleading:"1ex",indentshift:"auto",indentalign:a.INDENTALIGN.AUTO,indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,decimalseparator:".",texprimestyle:false},autoDefault:function(d){if(d==="displaystyle"){return this.Get("display")==="block"}return""},linebreakContainer:true,setTeXclass:a.mbase.setChildTeXclass,getAnnotation:function(d){if(this.data.length!=1){return null}return this.data[0].getAnnotation(d)}});a.chars=a.mbase.Subclass({type:"chars",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){return this.data.join("")},toString:function(){return this.data.join("")}});a.entity=a.mbase.Subclass({type:"entity",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){if(this.data[0].substr(0,2)==="#x"){return parseInt(this.data[0].substr(2),16)}else{if(this.data[0].substr(0,1)==="#"){return parseInt(this.data[0].substr(1))}else{return 0}}},toString:function(){var d=this.value();if(d<=65535){return String.fromCharCode(d)}d-=65536;return String.fromCharCode((d>>10)+55296)+String.fromCharCode((d&1023)+56320)}});a.xml=a.mbase.Subclass({type:"xml",Init:function(){this.div=document.createElement("div");return this.SUPER(arguments).Init.apply(this,arguments)},Append:function(){for(var e=0,d=arguments.length;e<d;e++){var f=this.Import(arguments[e]);this.data.push(f);this.div.appendChild(f)}},Import:function(h){if(document.importNode){return document.importNode(h,true)}var e,f,d;if(h.nodeType===1){e=document.createElement(h.nodeName);for(f=0,d=h.attributes.length;f<d;f++){var g=h.attributes[f];if(g.specified&&g.nodeValue!=null&&g.nodeValue!=""){e.setAttribute(g.nodeName,g.nodeValue)}if(g.nodeName==="style"){e.style.cssText=g.nodeValue}}if(h.className){e.className=h.className}}else{if(h.nodeType===3||h.nodeType===4){e=document.createTextNode(h.nodeValue)}else{if(h.nodeType===8){e=document.createComment(h.nodeValue)}else{return document.createTextNode("")}}}for(f=0,d=h.childNodes.length;f<d;f++){e.appendChild(this.Import(h.childNodes[f]))}return e},value:function(){return this.div},toString:function(){return this.div.innerHTML}});a.TeXAtom=a.mbase.Subclass({type:"texatom",inferRow:true,notParent:true,texClass:a.TEXCLASS.ORD,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,isEmbellished:a.mbase.childEmbellished,setTeXclass:function(d){this.data[0].setTeXclass();return this.adjustTeXclass(d)},adjustTeXclass:a.mo.prototype.adjustTeXclass});a.NULL=a.mbase().With({type:"null"});var b=a.TEXCLASS;var c={ORD:[0,0,b.ORD],ORD11:[1,1,b.ORD],ORD21:[2,1,b.ORD],ORD02:[0,2,b.ORD],ORD55:[5,5,b.ORD],OP:[1,2,b.OP,{largeop:true,movablelimits:true,symmetric:true}],OPFIXED:[1,2,b.OP,{largeop:true,movablelimits:true}],INTEGRAL:[0,1,b.OP,{largeop:true,symmetric:true}],INTEGRAL2:[1,2,b.OP,{largeop:true,symmetric:true}],BIN3:[3,3,b.BIN],BIN4:[4,4,b.BIN],BIN01:[0,1,b.BIN],BIN5:[5,5,b.BIN],TALLBIN:[4,4,b.BIN,{stretchy:true}],BINOP:[4,4,b.BIN,{largeop:true,movablelimits:true}],REL:[5,5,b.REL],REL1:[1,1,b.REL,{stretchy:true}],REL4:[4,4,b.REL],RELSTRETCH:[5,5,b.REL,{stretchy:true}],RELACCENT:[5,5,b.REL,{accent:true}],WIDEREL:[5,5,b.REL,{accent:true,stretchy:true}],OPEN:[0,0,b.OPEN,{fence:true,stretchy:true,symmetric:true}],CLOSE:[0,0,b.CLOSE,{fence:true,stretchy:true,symmetric:true}],INNER:[0,0,b.INNER],PUNCT:[0,3,b.PUNCT],ACCENT:[0,0,b.ORD,{accent:true}],WIDEACCENT:[0,0,b.ORD,{accent:true,stretchy:true}]};a.mo.Augment({SPACE:["0em","0.1111em","0.1667em","0.2222em","0.2667em","0.3333em"],RANGES:[[32,127,b.REL,"BasicLatin"],[160,255,b.ORD,"Latin1Supplement"],[256,383,b.ORD],[384,591,b.ORD],[688,767,b.ORD,"SpacingModLetters"],[768,879,b.ORD,"CombDiacritMarks"],[880,1023,b.ORD,"GreekAndCoptic"],[7680,7935,b.ORD],[8192,8303,b.PUNCT,"GeneralPunctuation"],[8304,8351,b.ORD],[8352,8399,b.ORD],[8400,8447,b.ORD,"CombDiactForSymbols"],[8448,8527,b.ORD,"LetterlikeSymbols"],[8528,8591,b.ORD],[8592,8703,b.REL,"Arrows"],[8704,8959,b.BIN,"MathOperators"],[8960,9215,b.ORD,"MiscTechnical"],[9312,9471,b.ORD],[9472,9631,b.ORD],[9632,9727,b.ORD,"GeometricShapes"],[9984,10175,b.ORD,"Dingbats"],[10176,10223,b.ORD,"MiscMathSymbolsA"],[10224,10239,b.REL,"SupplementalArrowsA"],[10496,10623,b.REL,"SupplementalArrowsB"],[10624,10751,b.ORD,"MiscMathSymbolsB"],[10752,11007,b.BIN,"SuppMathOperators"],[11008,11263,b.ORD,"MiscSymbolsAndArrows"],[119808,120831,b.ORD]],OPTABLE:{prefix:{"\u2200":c.ORD21,"\u2202":c.ORD21,"\u2203":c.ORD21,"\u2207":c.ORD21,"\u220F":c.OP,"\u2210":c.OP,"\u2211":c.OP,"\u2212":c.BIN01,"\u2213":c.BIN01,"\u221A":[1,1,b.ORD,{stretchy:true}],"\u2220":c.ORD,"\u222B":c.INTEGRAL,"\u222E":c.INTEGRAL,"\u22C0":c.OP,"\u22C1":c.OP,"\u22C2":c.OP,"\u22C3":c.OP,"\u2308":c.OPEN,"\u230A":c.OPEN,"\u27E8":c.OPEN,"\u27EE":c.OPEN,"\u2A00":c.OP,"\u2A01":c.OP,"\u2A02":c.OP,"\u2A04":c.OP,"\u2A06":c.OP,"\u00AC":c.ORD21,"\u00B1":c.BIN01,"(":c.OPEN,"+":c.BIN01,"-":c.BIN01,"[":c.OPEN,"{":c.OPEN,"|":c.OPEN},postfix:{"!":[1,0,b.CLOSE],"&":c.ORD,"\u2032":c.ORD02,"\u203E":c.WIDEACCENT,"\u2309":c.CLOSE,"\u230B":c.CLOSE,"\u23DE":c.WIDEACCENT,"\u23DF":c.WIDEACCENT,"\u266D":c.ORD02,"\u266E":c.ORD02,"\u266F":c.ORD02,"\u27E9":c.CLOSE,"\u27EF":c.CLOSE,"\u02C6":c.WIDEACCENT,"\u02C7":c.WIDEACCENT,"\u02C9":c.WIDEACCENT,"\u02CA":c.ACCENT,"\u02CB":c.ACCENT,"\u02D8":c.ACCENT,"\u02D9":c.ACCENT,"\u02DC":c.WIDEACCENT,"\u0302":c.WIDEACCENT,"\u00A8":c.ACCENT,"\u00AF":c.WIDEACCENT,")":c.CLOSE,"]":c.CLOSE,"^":c.WIDEACCENT,_:c.WIDEACCENT,"`":c.ACCENT,"|":c.CLOSE,"}":c.CLOSE,"~":c.WIDEACCENT},infix:{"":c.ORD,"%":[3,3,b.ORD],"\u2022":c.BIN4,"\u2026":c.INNER,"\u2044":c.TALLBIN,"\u2061":c.ORD,"\u2062":c.ORD,"\u2063":[0,0,b.ORD,{linebreakstyle:"after",separator:true}],"\u2064":c.ORD,"\u2190":c.WIDEREL,"\u2191":c.RELSTRETCH,"\u2192":c.WIDEREL,"\u2193":c.RELSTRETCH,"\u2194":c.WIDEREL,"\u2195":c.RELSTRETCH,"\u2196":c.RELSTRETCH,"\u2197":c.RELSTRETCH,"\u2198":c.RELSTRETCH,"\u2199":c.RELSTRETCH,"\u21A6":c.WIDEREL,"\u21A9":c.WIDEREL,"\u21AA":c.WIDEREL,"\u21BC":c.WIDEREL,"\u21BD":c.WIDEREL,"\u21C0":c.WIDEREL,"\u21C1":c.WIDEREL,"\u21CC":c.WIDEREL,"\u21D0":c.WIDEREL,"\u21D1":c.RELSTRETCH,"\u21D2":c.WIDEREL,"\u21D3":c.RELSTRETCH,"\u21D4":c.WIDEREL,"\u21D5":c.RELSTRETCH,"\u2208":c.REL,"\u2209":c.REL,"\u220B":c.REL,"\u2212":c.BIN4,"\u2213":c.BIN4,"\u2215":c.TALLBIN,"\u2216":c.BIN4,"\u2217":c.BIN4,"\u2218":c.BIN4,"\u2219":c.BIN4,"\u221D":c.REL,"\u2223":c.REL,"\u2225":c.REL,"\u2227":c.BIN4,"\u2228":c.BIN4,"\u2229":c.BIN4,"\u222A":c.BIN4,"\u223C":c.REL,"\u2240":c.BIN4,"\u2243":c.REL,"\u2245":c.REL,"\u2248":c.REL,"\u224D":c.REL,"\u2250":c.REL,"\u2260":c.REL,"\u2261":c.REL,"\u2264":c.REL,"\u2265":c.REL,"\u226A":c.REL,"\u226B":c.REL,"\u227A":c.REL,"\u227B":c.REL,"\u2282":c.REL,"\u2283":c.REL,"\u2286":c.REL,"\u2287":c.REL,"\u228E":c.BIN4,"\u2291":c.REL,"\u2292":c.REL,"\u2293":c.BIN4,"\u2294":c.BIN4,"\u2295":c.BIN4,"\u2296":c.BIN4,"\u2297":c.BIN4,"\u2298":c.BIN4,"\u2299":c.BIN4,"\u22A2":c.REL,"\u22A3":c.REL,"\u22A4":c.ORD55,"\u22A5":c.REL,"\u22A8":c.REL,"\u22C4":c.BIN4,"\u22C5":c.BIN4,"\u22C6":c.BIN4,"\u22C8":c.REL,"\u22EE":c.ORD55,"\u22EF":c.INNER,"\u22F1":[5,5,b.INNER],"\u25B3":c.BIN4,"\u25B5":c.BIN4,"\u25B9":c.BIN4,"\u25BD":c.BIN4,"\u25BF":c.BIN4,"\u25C3":c.BIN4,"\u2758":c.REL,"\u27F5":c.WIDEREL,"\u27F6":c.WIDEREL,"\u27F7":c.WIDEREL,"\u27F8":c.WIDEREL,"\u27F9":c.WIDEREL,"\u27FA":c.WIDEREL,"\u27FC":c.WIDEREL,"\u2A2F":c.BIN4,"\u2A3F":c.BIN4,"\u2AAF":c.REL,"\u2AB0":c.REL,"\u00B1":c.BIN4,"\u00B7":c.BIN4,"\u00D7":c.BIN4,"\u00F7":c.BIN4,"*":c.BIN3,"+":c.BIN4,",":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"-":c.BIN4,".":[3,3,b.ORD],"/":c.ORD11,":":[1,2,b.REL],";":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"<":c.REL,"=":c.REL,">":c.REL,"?":[1,1,b.CLOSE],"\\":c.ORD,"^":c.ORD11,_:c.ORD11,"|":[2,2,b.ORD,{fence:true,stretchy:true,symmetric:true}],"#":c.ORD,"$":c.ORD,"\u002E":[0,3,b.PUNCT,{separator:true}],"\u02B9":c.ORD,"\u0300":c.ACCENT,"\u0301":c.ACCENT,"\u0303":c.WIDEACCENT,"\u0304":c.ACCENT,"\u0306":c.ACCENT,"\u0307":c.ACCENT,"\u0308":c.ACCENT,"\u030C":c.ACCENT,"\u0332":c.WIDEACCENT,"\u0338":c.REL4,"\u2015":[0,0,b.ORD,{stretchy:true}],"\u2017":[0,0,b.ORD,{stretchy:true}],"\u2020":c.BIN3,"\u2021":c.BIN3,"\u20D7":c.ACCENT,"\u2111":c.ORD,"\u2113":c.ORD,"\u2118":c.ORD,"\u211C":c.ORD,"\u2205":c.ORD,"\u221E":c.ORD,"\u2305":c.BIN3,"\u2306":c.BIN3,"\u2322":c.REL4,"\u2323":c.REL4,"\u2329":c.OPEN,"\u232A":c.CLOSE,"\u23AA":c.ORD,"\u23AF":[0,0,b.ORD,{stretchy:true}],"\u23B0":c.OPEN,"\u23B1":c.CLOSE,"\u2500":c.ORD,"\u25EF":c.BIN3,"\u2660":c.ORD,"\u2661":c.ORD,"\u2662":c.ORD,"\u2663":c.ORD,"\u3008":c.OPEN,"\u3009":c.CLOSE,"\uFE37":c.WIDEACCENT,"\uFE38":c.WIDEACCENT}}},{OPTYPES:c});a.mo.prototype.OPTABLE.infix["^"]=c.WIDEREL;a.mo.prototype.OPTABLE.infix._=c.WIDEREL})(MathJax.ElementJax.mml);MathJax.ElementJax.mml.loadComplete("jax.js");
MathJax.Hub.Register.LoadHook("[MathJax]/jax/element/mml/jax.js",function(){var b="2.3";var a=MathJax.ElementJax.mml;SETTINGS=MathJax.Hub.config.menuSettings;a.mbase.Augment({toMathML:function(k){var g=(this.inferred&&this.parent.inferRow);if(k==null){k=""}var e=this.type,d=this.toMathMLattributes();if(e==="mspace"){return k+"<"+e+d+" />"}var j=[];var h=(this.isToken?"":k+(g?"":"  "));for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){j.push(this.data[f].toMathML(h))}else{if(!this.isToken){j.push(h+"<mrow />")}}}if(this.isToken){return k+"<"+e+d+">"+j.join("")+"</"+e+">"}if(g){return j.join("\n")}if(j.length===0||(j.length===1&&j[0]==="")){return k+"<"+e+d+" />"}return k+"<"+e+d+">\n"+j.join("\n")+"\n"+k+"</"+e+">"},toMathMLattributes:function(){var j=[],g=this.defaults;var c=(this.attrNames||a.copyAttributeNames),l=a.skipAttributes;if(this.type==="math"&&(!this.attr||!this.attr.xmlns)){j.push('xmlns="http://www.w3.org/1998/Math/MathML"')}if(!this.attrNames){if(this.type==="mstyle"){g=a.math.prototype.defaults}for(var d in g){if(!l[d]&&g.hasOwnProperty(d)){var e=(d==="open"||d==="close");if(this[d]!=null&&(e||this[d]!==g[d])){var k=this[d];delete this[d];if(e||this.Get(d)!==k){j.push(d+'="'+this.toMathMLattribute(k)+'"')}this[d]=k}}}}for(var h=0,f=c.length;h<f;h++){if(c[h]==="class"){continue}k=(this.attr||{})[c[h]];if(k==null){k=this[c[h]]}if(k!=null){j.push(c[h]+'="'+this.toMathMLquote(k)+'"')}}this.toMathMLclass(j);if(j.length){return" "+j.join(" ")}else{return""}},toMathMLclass:function(c){var e=[];if(this["class"]){e.push(this["class"])}if(this.isa(a.TeXAtom)&&SETTINGS.texHints){var d=["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"][this.texClass];if(d){e.push("MJX-TeXAtom-"+d)}}if(this.mathvariant&&this.toMathMLvariants[this.mathvariant]){e.push("MJX"+this.mathvariant)}if(this.variantForm){e.push("MJX-variant")}if(e.length){c.unshift('class="'+e.join(" ")+'"')}},toMathMLattribute:function(c){if(typeof(c)==="string"&&c.replace(/ /g,"").match(/^(([-+])?(\d+(\.\d*)?|\.\d+))mu$/)){return RegExp.$2+((1/18)*RegExp.$3).toFixed(3).replace(/\.?0+$/,"")+"em"}else{if(this.toMathMLvariants[c]){return this.toMathMLvariants[c]}}return this.toMathMLquote(c)},toMathMLvariants:{"-tex-caligraphic":a.VARIANT.SCRIPT,"-tex-caligraphic-bold":a.VARIANT.BOLDSCRIPT,"-tex-oldstyle":a.VARIANT.NORMAL,"-tex-oldstyle-bold":a.VARIANT.BOLD,"-tex-mathit":a.VARIANT.ITALIC},toMathMLquote:function(f){f=String(f).split("");for(var g=0,d=f.length;g<d;g++){var k=f[g].charCodeAt(0);if(k<=55295||57344<=k){if(k<32||k>126){f[g]="&#x"+k.toString(16).toUpperCase()+";"}else{var j={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;"}[f[g]];if(j){f[g]=j}}}else{if(g+1<d){var h=f[g+1].charCodeAt(0);var e=(((k-55296)<<10)+(h-56320)+65536);f[g]="&#x"+e.toString(16).toUpperCase()+";";f[g+1]="";g++}else{f[g]=""}}}return f.join("")}});a.msubsup.Augment({toMathML:function(h){var e=this.type;if(this.data[this.sup]==null){e="msub"}if(this.data[this.sub]==null){e="msup"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.munderover.Augment({toMathML:function(h){var e=this.type;if(this.data[this.under]==null){e="mover"}if(this.data[this.over]==null){e="munder"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.TeXAtom.Augment({toMathML:function(d){var c=this.toMathMLattributes();if(!c&&this.data[0].data.length===1){return d.substr(2)+this.data[0].toMathML(d)}return d+"<mrow"+c+">\n"+this.data[0].toMathML(d+"  ")+"\n"+d+"</mrow>"}});a.chars.Augment({toMathML:function(c){return(c||"")+this.toMathMLquote(this.toString())}});a.entity.Augment({toMathML:function(c){return(c||"")+"&"+this.data[0]+";<!-- "+this.toString()+" -->"}});a.xml.Augment({toMathML:function(c){return(c||"")+this.toString()}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toMathML:function(c){return this.Core().toMathML(c)}})});MathJax.Hub.Startup.signal.Post("toMathML Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/toMathML.js");
(function(c,d){var a;var b=function(e){return MathJax.Localization._.apply(MathJax.Localization,[["MathML",e]].concat([].slice.call(arguments,1)))};c.Parse=MathJax.Object.Subclass({Init:function(e){this.Parse(e)},Parse:function(g){var h;if(typeof g!=="string"){h=g.parentNode}else{h=c.ParseXML(this.preProcessMath.call(this,g));if(h==null){c.Error(["ErrorParsingMathML","Error parsing MathML"])}}var f=h.getElementsByTagName("parsererror")[0];if(f){c.Error(["ParsingError","Error parsing MathML: %1",f.textContent.replace(/This page.*?errors:|XML Parsing Error: |Below is a rendering of the page.*/g,"")])}if(h.childNodes.length!==1){c.Error(["MathMLSingleElement","MathML must be formed by a single element"])}if(h.firstChild.nodeName.toLowerCase()==="html"){var e=h.getElementsByTagName("h1")[0];if(e&&e.textContent==="XML parsing error"&&e.nextSibling){c.Error(["ParsingError","Error parsing MathML: %1",String(e.nextSibling.nodeValue).replace(/fatal parsing error: /,"")])}}if(h.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")!=="math"){c.Error(["MathMLRootElement","MathML must be formed by a <math> element, not %1","<"+h.firstChild.nodeName+">"])}this.mml=this.MakeMML(h.firstChild)},MakeMML:function(h){var i=String(h.getAttribute("class")||"");var f,g=h.nodeName.toLowerCase().replace(/^[a-z]+:/,"");var e=(i.match(/(^| )MJX-TeXAtom-([^ ]*)/));if(e){f=this.TeXAtom(e[2])}else{if(!(a[g]&&a[g].isa&&a[g].isa(a.mbase))){MathJax.Hub.signal.Post(["MathML Jax - unknown node type",g]);return a.Error(b("UnknownNodeType","Unknown node type: %1",g))}else{f=a[g]()}}this.AddAttributes(f,h);this.CheckClass(f,f["class"]);this.AddChildren(f,h);if(c.config.useMathMLspacing){f.useMMLspacing=8}return f},TeXAtom:function(f){var e=a.TeXAtom().With({texClass:a.TEXCLASS[f]});if(e.texClass===a.TEXCLASS.OP){e.movesupsub=e.movablelimits=true}return e},CheckClass:function(f,h){h=(h||"").split(/ /);var j=[];for(var g=0,e=h.length;g<e;g++){if(h[g].substr(0,4)==="MJX-"){if(h[g]==="MJX-arrow"){if(!f.notation.match("/"+a.NOTATION.UPDIAGONALARROW+"/")){f.notation+=" "+a.NOTATION.UPDIAGONALARROW}}else{if(h[g]==="MJX-variant"){f.variantForm=true;if(!MathJax.Extension["TeX/AMSsymbols"]){MathJax.Hub.RestartAfter(MathJax.Ajax.Require("[MathJax]/extensions/TeX/AMSsymbols.js"))}}else{if(h[g].substr(0,11)!=="MJX-TeXAtom"){f.mathvariant=h[g].substr(3);if(f.mathvariant==="-tex-caligraphic-bold"||f.mathvariant==="-tex-oldstyle-bold"){if(!MathJax.Extension["TeX/boldsymbol"]){MathJax.Hub.RestartAfter(MathJax.Ajax.Require("[MathJax]/extensions/TeX/boldsymbol.js"))}}}}}}else{j.push(h[g])}}if(j.length){f["class"]=j.join(" ")}else{delete f["class"]}},AddAttributes:function(g,j){g.attr={};g.attrNames=[];for(var h=0,e=j.attributes.length;h<e;h++){var f=j.attributes[h].name;if(f=="xlink:href"){f="href"}if(f.match(/:/)){continue}if(f.match(/^_moz-math-((column|row)(align|line)|font-style)$/)){continue}var k=j.attributes[h].value;k=this.filterAttribute(f,k);if(k!=null){if(k.toLowerCase()==="true"){k=true}else{if(k.toLowerCase()==="false"){k=false}}if(g.defaults[f]!=null||a.copyAttributes[f]){g[f]=k}else{g.attr[f]=k}g.attrNames.push(f)}}},filterAttribute:function(e,f){return f},AddChildren:function(e,g){for(var k=0,j=g.childNodes.length;k<j;k++){var f=g.childNodes[k];if(f.nodeName==="#comment"){continue}if(f.nodeName==="#text"){if(e.isToken&&!e.mmlSelfClosing){var o=f.nodeValue.replace(/&([a-z][a-z0-9]*);/ig,this.replaceEntity);e.Append(a.chars(this.trimSpace(o)))}else{if(f.nodeValue.match(/\S/)){c.Error(["UnexpectedTextNode","Unexpected text node: %1","'"+f.nodeValue+"'"])}}}else{if(e.type==="annotation-xml"){e.Append(a.xml(f))}else{var h=this.MakeMML(f);e.Append(h);if(h.mmlSelfClosing&&h.data.length){e.Append.apply(e,h.data);h.data=[]}}}}if(e.type==="mrow"&&e.data.length>=2){var l=e.data[0],n=e.data[e.data.length-1];if(l.type==="mo"&&l.Get("fence")&&n.type==="mo"&&n.Get("fence")){if(l.data[0]){e.open=l.data.join("")}if(n.data[0]){e.close=n.data.join("")}}}},preProcessMath:function(f){if(f.match(/^<[a-z]+:/i)&&!f.match(/^<[^<>]* xmlns:/)){f=f.replace(/^<([a-z]+)(:math)/i,'<$1$2 xmlns:$1="http://www.w3.org/1998/Math/MathML"')}var e=f.match(/^(<math( ('.*?'|".*?"|[^>])+)>)/i);if(e&&e[2].match(/ (?!xmlns=)[a-z]+=\"http:/i)){f=e[1].replace(/ (?!xmlns=)([a-z]+=(['"])http:.*?\2)/ig," xmlns:$1 $1")+f.substr(e[0].length)}if(f.match(/^<math/i)&&!f.match(/^<[^<>]* xmlns=/)){f=f.replace(/^<(math)/i,'<math xmlns="http://www.w3.org/1998/Math/MathML"')}f=f.replace(/^\s*(?:\/\/)?<!(--)?\[CDATA\[((.|\n)*)(\/\/)?\]\]\1>\s*$/,"$2");return f.replace(/&([a-z][a-z0-9]*);/ig,this.replaceEntity)},trimSpace:function(e){return e.replace(/[\t\n\r]/g," ").replace(/^ +/,"").replace(/ +$/,"").replace(/  +/g," ")},replaceEntity:function(g,f){if(f.match(/^(lt|amp|quot)$/)){return g}if(c.Parse.Entity[f]){return c.Parse.Entity[f]}var h=f.charAt(0).toLowerCase();var e=f.match(/^[a-zA-Z](fr|scr|opf)$/);if(e){h=e[1]}if(!c.Parse.loaded[h]){c.Parse.loaded[h]=true;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(c.entityDir+"/"+h+".js"))}return g}},{loaded:[]});c.Augment({sourceMenuTitle:["OriginalMathML","Original MathML"],prefilterHooks:MathJax.Callback.Hooks(true),postfilterHooks:MathJax.Callback.Hooks(true),Translate:function(e){if(!this.ParseXML){this.ParseXML=this.createParser()}var f,h,i={script:e};if(e.firstChild&&e.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")==="math"){i.math=e.firstChild;this.prefilterHooks.Execute(i);h=i.math}else{h=MathJax.HTML.getScript(e);if(d.isMSIE){h=h.replace(/(&nbsp;)+$/,"")}i.math=h;this.prefilterHooks.Execute(i);h=i.math}try{f=c.Parse(h).mml}catch(g){if(!g.mathmlError){throw g}f=this.formatError(g,h,e)}i.math=a(f);this.postfilterHooks.Execute(i);return i.math},prefilterMath:function(f,e){return f},prefilterMathML:function(f,e){return f},formatError:function(h,g,e){var f=h.message.replace(/\n.*/,"");MathJax.Hub.signal.Post(["MathML Jax - parse error",f,g,e]);return a.Error(f)},Error:function(e){if(e instanceof Array){e=b.apply(b,e)}throw MathJax.Hub.Insert(Error(e),{mathmlError:true})},parseDOM:function(e){return this.parser.parseFromString(e,"text/xml")},parseMS:function(e){return(this.parser.loadXML(e)?this.parser:null)},parseDIV:function(e){this.div.innerHTML=e.replace(/<([a-z]+)([^>]*)\/>/g,"<$1$2></$1>");return this.div},parseError:function(e){return null},createMSParser:function(){var j=null;var f=["MSXML2.DOMDocument.6.0","MSXML2.DOMDocument.5.0","MSXML2.DOMDocument.4.0","MSXML2.DOMDocument.3.0","MSXML2.DOMDocument.2.0","Microsoft.XMLDOM"];for(var g=0,e=f.length;g<e&&!j;g++){try{j=new ActiveXObject(f[g])}catch(h){}}return j},createParser:function(){if(window.DOMParser){this.parser=new DOMParser();return(this.parseDOM)}else{if(window.ActiveXObject){this.parser=this.createMSParser();if(!this.parser){MathJax.Localization.Try(this.parserCreationError);return(this.parseError)}this.parser.async=false;return(this.parseMS)}}this.div=MathJax.Hub.Insert(document.createElement("div"),{style:{visibility:"hidden",overflow:"hidden",height:"1px",position:"absolute",top:0}});if(!document.body.firstChild){document.body.appendChild(this.div)}else{document.body.insertBefore(this.div,document.body.firstChild)}return(this.parseDIV)},parserCreationError:function(){alert(b("CantCreateXMLParser","MathJax can't create an XML parser for MathML.  Check that\nthe 'Script ActiveX controls marked safe for scripting' security\nsetting is enabled (use the Internet Options item in the Tools\nmenu, and select the Security panel, then press the Custom Level\nbutton to check this).\n\nMathML equations will not be able to be processed by MathJax."))},Startup:function(){a=MathJax.ElementJax.mml;a.mspace.Augment({mmlSelfClosing:true});a.none.Augment({mmlSelfClosing:true});a.mprescripts.Augment({mmlSelfClosing:true})}});c.prefilterHooks.Add(function(e){e.math=(typeof(e.math)==="string"?c.prefilterMath(e.math,e.script):c.prefilterMathML(e.math,e.script))});c.Parse.Entity={ApplyFunction:"\u2061",Backslash:"\u2216",Because:"\u2235",Breve:"\u02D8",Cap:"\u22D2",CenterDot:"\u00B7",CircleDot:"\u2299",CircleMinus:"\u2296",CirclePlus:"\u2295",CircleTimes:"\u2297",Congruent:"\u2261",ContourIntegral:"\u222E",Coproduct:"\u2210",Cross:"\u2A2F",Cup:"\u22D3",CupCap:"\u224D",Dagger:"\u2021",Del:"\u2207",Delta:"\u0394",Diamond:"\u22C4",DifferentialD:"\u2146",DotEqual:"\u2250",DoubleDot:"\u00A8",DoubleRightTee:"\u22A8",DoubleVerticalBar:"\u2225",DownArrow:"\u2193",DownLeftVector:"\u21BD",DownRightVector:"\u21C1",DownTee:"\u22A4",Downarrow:"\u21D3",Element:"\u2208",EqualTilde:"\u2242",Equilibrium:"\u21CC",Exists:"\u2203",ExponentialE:"\u2147",FilledVerySmallSquare:"\u25AA",ForAll:"\u2200",Gamma:"\u0393",Gg:"\u22D9",GreaterEqual:"\u2265",GreaterEqualLess:"\u22DB",GreaterFullEqual:"\u2267",GreaterLess:"\u2277",GreaterSlantEqual:"\u2A7E",GreaterTilde:"\u2273",Hacek:"\u02C7",Hat:"\u005E",HumpDownHump:"\u224E",HumpEqual:"\u224F",Im:"\u2111",ImaginaryI:"\u2148",Integral:"\u222B",Intersection:"\u22C2",InvisibleComma:"\u2063",InvisibleTimes:"\u2062",Lambda:"\u039B",Larr:"\u219E",LeftAngleBracket:"\u27E8",LeftArrow:"\u2190",LeftArrowRightArrow:"\u21C6",LeftCeiling:"\u2308",LeftDownVector:"\u21C3",LeftFloor:"\u230A",LeftRightArrow:"\u2194",LeftTee:"\u22A3",LeftTriangle:"\u22B2",LeftTriangleEqual:"\u22B4",LeftUpVector:"\u21BF",LeftVector:"\u21BC",Leftarrow:"\u21D0",Leftrightarrow:"\u21D4",LessEqualGreater:"\u22DA",LessFullEqual:"\u2266",LessGreater:"\u2276",LessSlantEqual:"\u2A7D",LessTilde:"\u2272",Ll:"\u22D8",Lleftarrow:"\u21DA",LongLeftArrow:"\u27F5",LongLeftRightArrow:"\u27F7",LongRightArrow:"\u27F6",Longleftarrow:"\u27F8",Longleftrightarrow:"\u27FA",Longrightarrow:"\u27F9",Lsh:"\u21B0",MinusPlus:"\u2213",NestedGreaterGreater:"\u226B",NestedLessLess:"\u226A",NotDoubleVerticalBar:"\u2226",NotElement:"\u2209",NotEqual:"\u2260",NotExists:"\u2204",NotGreater:"\u226F",NotGreaterEqual:"\u2271",NotLeftTriangle:"\u22EA",NotLeftTriangleEqual:"\u22EC",NotLess:"\u226E",NotLessEqual:"\u2270",NotPrecedes:"\u2280",NotPrecedesSlantEqual:"\u22E0",NotRightTriangle:"\u22EB",NotRightTriangleEqual:"\u22ED",NotSubsetEqual:"\u2288",NotSucceeds:"\u2281",NotSucceedsSlantEqual:"\u22E1",NotSupersetEqual:"\u2289",NotTilde:"\u2241",NotVerticalBar:"\u2224",Omega:"\u03A9",OverBar:"\u203E",OverBrace:"\u23DE",PartialD:"\u2202",Phi:"\u03A6",Pi:"\u03A0",PlusMinus:"\u00B1",Precedes:"\u227A",PrecedesEqual:"\u2AAF",PrecedesSlantEqual:"\u227C",PrecedesTilde:"\u227E",Product:"\u220F",Proportional:"\u221D",Psi:"\u03A8",Rarr:"\u21A0",Re:"\u211C",ReverseEquilibrium:"\u21CB",RightAngleBracket:"\u27E9",RightArrow:"\u2192",RightArrowLeftArrow:"\u21C4",RightCeiling:"\u2309",RightDownVector:"\u21C2",RightFloor:"\u230B",RightTee:"\u22A2",RightTeeArrow:"\u21A6",RightTriangle:"\u22B3",RightTriangleEqual:"\u22B5",RightUpVector:"\u21BE",RightVector:"\u21C0",Rightarrow:"\u21D2",Rrightarrow:"\u21DB",Rsh:"\u21B1",Sigma:"\u03A3",SmallCircle:"\u2218",Sqrt:"\u221A",Square:"\u25A1",SquareIntersection:"\u2293",SquareSubset:"\u228F",SquareSubsetEqual:"\u2291",SquareSuperset:"\u2290",SquareSupersetEqual:"\u2292",SquareUnion:"\u2294",Star:"\u22C6",Subset:"\u22D0",SubsetEqual:"\u2286",Succeeds:"\u227B",SucceedsEqual:"\u2AB0",SucceedsSlantEqual:"\u227D",SucceedsTilde:"\u227F",SuchThat:"\u220B",Sum:"\u2211",Superset:"\u2283",SupersetEqual:"\u2287",Supset:"\u22D1",Therefore:"\u2234",Theta:"\u0398",Tilde:"\u223C",TildeEqual:"\u2243",TildeFullEqual:"\u2245",TildeTilde:"\u2248",UnderBar:"\u005F",UnderBrace:"\u23DF",Union:"\u22C3",UnionPlus:"\u228E",UpArrow:"\u2191",UpDownArrow:"\u2195",UpTee:"\u22A5",Uparrow:"\u21D1",Updownarrow:"\u21D5",Upsilon:"\u03A5",Vdash:"\u22A9",Vee:"\u22C1",VerticalBar:"\u2223",VerticalTilde:"\u2240",Vvdash:"\u22AA",Wedge:"\u22C0",Xi:"\u039E",acute:"\u00B4",aleph:"\u2135",alpha:"\u03B1",amalg:"\u2A3F",and:"\u2227",ang:"\u2220",angmsd:"\u2221",angsph:"\u2222",ape:"\u224A",backprime:"\u2035",backsim:"\u223D",backsimeq:"\u22CD",beta:"\u03B2",beth:"\u2136",between:"\u226C",bigcirc:"\u25EF",bigodot:"\u2A00",bigoplus:"\u2A01",bigotimes:"\u2A02",bigsqcup:"\u2A06",bigstar:"\u2605",bigtriangledown:"\u25BD",bigtriangleup:"\u25B3",biguplus:"\u2A04",blacklozenge:"\u29EB",blacktriangle:"\u25B4",blacktriangledown:"\u25BE",blacktriangleleft:"\u25C2",bowtie:"\u22C8",boxdl:"\u2510",boxdr:"\u250C",boxminus:"\u229F",boxplus:"\u229E",boxtimes:"\u22A0",boxul:"\u2518",boxur:"\u2514",bsol:"\u005C",bull:"\u2022",cap:"\u2229",check:"\u2713",chi:"\u03C7",circ:"\u02C6",circeq:"\u2257",circlearrowleft:"\u21BA",circlearrowright:"\u21BB",circledR:"\u00AE",circledS:"\u24C8",circledast:"\u229B",circledcirc:"\u229A",circleddash:"\u229D",clubs:"\u2663",colon:"\u003A",comp:"\u2201",ctdot:"\u22EF",cuepr:"\u22DE",cuesc:"\u22DF",cularr:"\u21B6",cup:"\u222A",curarr:"\u21B7",curlyvee:"\u22CE",curlywedge:"\u22CF",dagger:"\u2020",daleth:"\u2138",ddarr:"\u21CA",deg:"\u00B0",delta:"\u03B4",digamma:"\u03DD",div:"\u00F7",divideontimes:"\u22C7",dot:"\u02D9",doteqdot:"\u2251",dotplus:"\u2214",dotsquare:"\u22A1",dtdot:"\u22F1",ecir:"\u2256",efDot:"\u2252",egs:"\u2A96",ell:"\u2113",els:"\u2A95",empty:"\u2205",epsi:"\u03B5",epsiv:"\u03F5",erDot:"\u2253",eta:"\u03B7",eth:"\u00F0",flat:"\u266D",fork:"\u22D4",frown:"\u2322",gEl:"\u2A8C",gamma:"\u03B3",gap:"\u2A86",gimel:"\u2137",gnE:"\u2269",gnap:"\u2A8A",gne:"\u2A88",gnsim:"\u22E7",gt:"\u003E",gtdot:"\u22D7",harrw:"\u21AD",hbar:"\u210F",hellip:"\u2026",hookleftarrow:"\u21A9",hookrightarrow:"\u21AA",imath:"\u0131",infin:"\u221E",intcal:"\u22BA",iota:"\u03B9",jmath:"\u0237",kappa:"\u03BA",kappav:"\u03F0",lEg:"\u2A8B",lambda:"\u03BB",lap:"\u2A85",larrlp:"\u21AB",larrtl:"\u21A2",lbrace:"\u007B",lbrack:"\u005B",le:"\u2264",leftleftarrows:"\u21C7",leftthreetimes:"\u22CB",lessdot:"\u22D6",lmoust:"\u23B0",lnE:"\u2268",lnap:"\u2A89",lne:"\u2A87",lnsim:"\u22E6",longmapsto:"\u27FC",looparrowright:"\u21AC",lowast:"\u2217",loz:"\u25CA",lt:"\u003C",ltimes:"\u22C9",ltri:"\u25C3",macr:"\u00AF",malt:"\u2720",mho:"\u2127",mu:"\u03BC",multimap:"\u22B8",nLeftarrow:"\u21CD",nLeftrightarrow:"\u21CE",nRightarrow:"\u21CF",nVDash:"\u22AF",nVdash:"\u22AE",natur:"\u266E",nearr:"\u2197",nharr:"\u21AE",nlarr:"\u219A",not:"\u00AC",nrarr:"\u219B",nu:"\u03BD",nvDash:"\u22AD",nvdash:"\u22AC",nwarr:"\u2196",omega:"\u03C9",omicron:"\u03BF",or:"\u2228",osol:"\u2298",period:"\u002E",phi:"\u03C6",phiv:"\u03D5",pi:"\u03C0",piv:"\u03D6",prap:"\u2AB7",precnapprox:"\u2AB9",precneqq:"\u2AB5",precnsim:"\u22E8",prime:"\u2032",psi:"\u03C8",rarrtl:"\u21A3",rbrace:"\u007D",rbrack:"\u005D",rho:"\u03C1",rhov:"\u03F1",rightrightarrows:"\u21C9",rightthreetimes:"\u22CC",ring:"\u02DA",rmoust:"\u23B1",rtimes:"\u22CA",rtri:"\u25B9",scap:"\u2AB8",scnE:"\u2AB6",scnap:"\u2ABA",scnsim:"\u22E9",sdot:"\u22C5",searr:"\u2198",sect:"\u00A7",sharp:"\u266F",sigma:"\u03C3",sigmav:"\u03C2",simne:"\u2246",smile:"\u2323",spades:"\u2660",sub:"\u2282",subE:"\u2AC5",subnE:"\u2ACB",subne:"\u228A",supE:"\u2AC6",supnE:"\u2ACC",supne:"\u228B",swarr:"\u2199",tau:"\u03C4",theta:"\u03B8",thetav:"\u03D1",tilde:"\u02DC",times:"\u00D7",triangle:"\u25B5",triangleq:"\u225C",upsi:"\u03C5",upuparrows:"\u21C8",veebar:"\u22BB",vellip:"\u22EE",weierp:"\u2118",xi:"\u03BE",yen:"\u00A5",zeta:"\u03B6",zigrarr:"\u21DD"};c.loadComplete("jax.js")})(MathJax.InputJax.MathML,MathJax.Hub.Browser);
MathJax.Ajax.loadComplete("[MathJax]/config/MML_HTMLorMML.js");
