/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware.novacominstaller;

import ca.canucksoftware.novacominstaller.DriverDownloader;
import ca.canucksoftware.novacominstaller.NovacomInstallerApp;
import ca.canucksoftware.utils.TextStreamConsumer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class NovacomInstallerView
extends FrameView {
    public Timer t;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel mainPanel;

    public NovacomInstallerView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            if (System.getenv("ProgramFiles(x86)") == null) {
                this.jLabel2.setText("Windows 32bit");
            } else {
                this.jLabel2.setText("Windows 64bit");
            }
        } else if (os.contains("mac")) {
            this.jLabel2.setText("Mac OS");
        } else if (os.contains("linux")) {
            if (!this.is64bitLinux()) {
                this.jLabel2.setText("Linux 32bit");
            } else {
                this.jLabel2.setText("Linux 64bit");
            }
        } else {
            this.jLabel2.setText("<unknown>");
        }
    }

    private boolean is64bitLinux() {
        boolean result = false;
        try {
            Process p = Runtime.getRuntime().exec("dpkg --print-architecture");
            OutputStream os = p.getOutputStream();
            os.flush();
            os.close();
            TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
            stdout.start();
            TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
            stderr.start();
            stdout.waitFor();
            result = !stdout.toString().toLowerCase().contains("i386");
        }
        catch (IOException e) {
            System.err.println("Unable to check Linux system architecture");
        }
        return result;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(NovacomInstallerApp.class).getContext().getResourceMap(NovacomInstallerView.class);
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setFont(resourceMap.getFont("jLabel2.font"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jButton1.setFont(resourceMap.getFont("jButton1.font"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NovacomInstallerView.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jLabel2, -2, 121, -2)).addComponent(this.jButton1, -2, 193, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 24, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1, -2, 53, -2).addContainerGap(16, Short.MAX_VALUE)));
        this.setComponent(this.mainPanel);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.t = new Timer();
        this.jButton1.setEnabled(false);
        this.jButton1.setText("Please wait...");
        this.t.schedule((TimerTask)new DoInstallation(), 200L);
    }

    class DoctorChooseFilter
    extends FileFilter {
        private final String[] okFileExtensions = new String[]{".jar"};

        DoctorChooseFilter() {
        }

        public boolean accept(File f) {
            for (String extension : this.okFileExtensions) {
                if (!f.getName().toLowerCase().endsWith(extension) && !f.isDirectory()) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "Jar Files (*.jar)";
        }
    }

    class DoInstallation
    extends TimerTask {
        DoInstallation() {
        }

        public void run() {
            JFrame mainFrame = NovacomInstallerApp.getApplication().getMainFrame();
            DriverDownloader downloader = new DriverDownloader(mainFrame);
            NovacomInstallerApp.getApplication().show(downloader);
            NovacomInstallerView.this.jButton1.setEnabled(true);
            NovacomInstallerView.this.jButton1.setText("Install Novacom");
        }
    }
}

